package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  DeleteStack,
  ClientRequestToken,
  ProjectId
}
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(
    id: ProjectId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    deleteStack: Optional[DeleteStack] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DeleteProjectRequest
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        deleteStack.map(value => DeleteStack.unwrap(value): java.lang.Boolean)
      )(_.deleteStack)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DeleteProjectRequest.ReadOnly =
    zio.aws.codestar.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DeleteProjectRequest =
      zio.aws.codestar.model.DeleteProjectRequest(
        id,
        clientRequestToken.map(value => value),
        deleteStack.map(value => value)
      )
    def id: ProjectId
    def clientRequestToken: Optional[ClientRequestToken]
    def deleteStack: Optional[DeleteStack]
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDeleteStack: ZIO[Any, AwsError, DeleteStack] =
      AwsError.unwrapOptionField("deleteStack", deleteStack)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DeleteProjectRequest
  ) extends zio.aws.codestar.model.DeleteProjectRequest.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codestar.model.primitives.ClientRequestToken(value)
        )
    override val deleteStack: Optional[DeleteStack] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteStack())
      .map(value => zio.aws.codestar.model.primitives.DeleteStack(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DeleteProjectRequest
  ): zio.aws.codestar.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
