package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{RemoteAccessAllowed, Role, UserArn}
import scala.jdk.CollectionConverters._
final case class UpdateTeamMemberResponse(
    userArn: Optional[UserArn] = Optional.Absent,
    projectRole: Optional[Role] = Optional.Absent,
    remoteAccessAllowed: Optional[RemoteAccessAllowed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse = {
    import UpdateTeamMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
      .builder()
      .optionallyWith(
        userArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        projectRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.projectRole)
      .optionallyWith(
        remoteAccessAllowed.map(value =>
          RemoteAccessAllowed.unwrap(value): java.lang.Boolean
        )
      )(_.remoteAccessAllowed)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly =
    zio.aws.codestar.model.UpdateTeamMemberResponse.wrap(buildAwsValue())
}
object UpdateTeamMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UpdateTeamMemberResponse =
      zio.aws.codestar.model.UpdateTeamMemberResponse(
        userArn.map(value => value),
        projectRole.map(value => value),
        remoteAccessAllowed.map(value => value)
      )
    def userArn: Optional[UserArn]
    def projectRole: Optional[Role]
    def remoteAccessAllowed: Optional[RemoteAccessAllowed]
    def getUserArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getProjectRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("projectRole", projectRole)
    def getRemoteAccessAllowed: ZIO[Any, AwsError, RemoteAccessAllowed] =
      AwsError.unwrapOptionField("remoteAccessAllowed", remoteAccessAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
  ) extends zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly {
    override val userArn: Optional[UserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.codestar.model.primitives.UserArn(value))
    override val projectRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.projectRole())
      .map(value => zio.aws.codestar.model.primitives.Role(value))
    override val remoteAccessAllowed: Optional[RemoteAccessAllowed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccessAllowed())
        .map(value =>
          zio.aws.codestar.model.primitives.RemoteAccessAllowed(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
  ): zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
