package zio.aws.codestar
import zio.aws.codestar.model.TagProjectResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.codestar.model.{
  ListUserProfilesRequest,
  CreateProjectRequest,
  TagProjectRequest,
  UpdateTeamMemberRequest,
  UpdateProjectRequest,
  AssociateTeamMemberRequest,
  DeleteProjectRequest,
  ListResourcesRequest,
  UntagProjectRequest,
  DisassociateTeamMemberRequest,
  ListProjectsRequest,
  DeleteUserProfileRequest,
  DescribeUserProfileRequest,
  ListTagsForProjectRequest,
  ListTeamMembersRequest,
  DescribeProjectRequest,
  CreateUserProfileRequest,
  UpdateUserProfileRequest
}
import software.amazon.awssdk.services.codestar.CodeStarAsyncClient
object CodeStarMock extends Mock[CodeStar] {
  object ListTeamMembers
      extends Effect[
        ListTeamMembersRequest,
        AwsError,
        zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly
      ]
  object ListUserProfiles
      extends Effect[
        ListUserProfilesRequest,
        AwsError,
        zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.codestar.model.UpdateProjectResponse.ReadOnly
      ]
  object TagProject extends Effect[TagProjectRequest, AwsError, ReadOnly]
  object UpdateUserProfile
      extends Effect[
        UpdateUserProfileRequest,
        AwsError,
        zio.aws.codestar.model.UpdateUserProfileResponse.ReadOnly
      ]
  object ListProjects
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.codestar.model.ListProjectsResponse.ReadOnly
      ]
  object UpdateTeamMember
      extends Effect[
        UpdateTeamMemberRequest,
        AwsError,
        zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.codestar.model.CreateProjectResponse.ReadOnly
      ]
  object ListResources
      extends Effect[
        ListResourcesRequest,
        AwsError,
        zio.aws.codestar.model.ListResourcesResponse.ReadOnly
      ]
  object ListTagsForProject
      extends Effect[
        ListTagsForProjectRequest,
        AwsError,
        zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly
      ]
  object DescribeProject
      extends Effect[
        DescribeProjectRequest,
        AwsError,
        zio.aws.codestar.model.DescribeProjectResponse.ReadOnly
      ]
  object DescribeUserProfile
      extends Effect[
        DescribeUserProfileRequest,
        AwsError,
        zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly
      ]
  object DeleteUserProfile
      extends Effect[
        DeleteUserProfileRequest,
        AwsError,
        zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.codestar.model.DeleteProjectResponse.ReadOnly
      ]
  object UntagProject
      extends Effect[
        UntagProjectRequest,
        AwsError,
        zio.aws.codestar.model.UntagProjectResponse.ReadOnly
      ]
  object CreateUserProfile
      extends Effect[
        CreateUserProfileRequest,
        AwsError,
        zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly
      ]
  object DisassociateTeamMember
      extends Effect[
        DisassociateTeamMemberRequest,
        AwsError,
        zio.aws.codestar.model.DisassociateTeamMemberResponse.ReadOnly
      ]
  object AssociateTeamMember
      extends Effect[
        AssociateTeamMemberRequest,
        AwsError,
        zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeStar] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new CodeStar {
          val api: CodeStarAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : CodeStar = this
          def listTeamMembers(request: ListTeamMembersRequest): IO[
            AwsError,
            zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly
          ] = proxy(ListTeamMembers, request)
          def listUserProfiles(request: ListUserProfilesRequest): IO[
            AwsError,
            zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly
          ] = proxy(ListUserProfiles, request)
          def updateProject(request: UpdateProjectRequest): IO[
            AwsError,
            zio.aws.codestar.model.UpdateProjectResponse.ReadOnly
          ] = proxy(UpdateProject, request)
          def tagProject(request: TagProjectRequest): IO[AwsError, ReadOnly] =
            proxy(TagProject, request)
          def updateUserProfile(request: UpdateUserProfileRequest): IO[
            AwsError,
            zio.aws.codestar.model.UpdateUserProfileResponse.ReadOnly
          ] = proxy(UpdateUserProfile, request)
          def listProjects(request: ListProjectsRequest): IO[
            AwsError,
            zio.aws.codestar.model.ListProjectsResponse.ReadOnly
          ] = proxy(ListProjects, request)
          def updateTeamMember(request: UpdateTeamMemberRequest): IO[
            AwsError,
            zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly
          ] = proxy(UpdateTeamMember, request)
          def createProject(request: CreateProjectRequest): IO[
            AwsError,
            zio.aws.codestar.model.CreateProjectResponse.ReadOnly
          ] = proxy(CreateProject, request)
          def listResources(request: ListResourcesRequest): IO[
            AwsError,
            zio.aws.codestar.model.ListResourcesResponse.ReadOnly
          ] = proxy(ListResources, request)
          def listTagsForProject(request: ListTagsForProjectRequest): IO[
            AwsError,
            zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly
          ] = proxy(ListTagsForProject, request)
          def describeProject(request: DescribeProjectRequest): IO[
            AwsError,
            zio.aws.codestar.model.DescribeProjectResponse.ReadOnly
          ] = proxy(DescribeProject, request)
          def describeUserProfile(request: DescribeUserProfileRequest): IO[
            AwsError,
            zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly
          ] = proxy(DescribeUserProfile, request)
          def deleteUserProfile(request: DeleteUserProfileRequest): IO[
            AwsError,
            zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly
          ] = proxy(DeleteUserProfile, request)
          def deleteProject(request: DeleteProjectRequest): IO[
            AwsError,
            zio.aws.codestar.model.DeleteProjectResponse.ReadOnly
          ] = proxy(DeleteProject, request)
          def untagProject(request: UntagProjectRequest): IO[
            AwsError,
            zio.aws.codestar.model.UntagProjectResponse.ReadOnly
          ] = proxy(UntagProject, request)
          def createUserProfile(request: CreateUserProfileRequest): IO[
            AwsError,
            zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly
          ] = proxy(CreateUserProfile, request)
          def disassociateTeamMember(
              request: DisassociateTeamMemberRequest
          ): IO[
            AwsError,
            zio.aws.codestar.model.DisassociateTeamMemberResponse.ReadOnly
          ] = proxy(DisassociateTeamMember, request)
          def associateTeamMember(request: AssociateTeamMemberRequest): IO[
            AwsError,
            zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly
          ] = proxy(AssociateTeamMember, request)
        }
      }
    }
  }
}
