package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Code(
    source: zio.aws.codestar.model.CodeSource,
    destination: zio.aws.codestar.model.CodeDestination
) {
  def buildAwsValue(): software.amazon.awssdk.services.codestar.model.Code = {
    import Code.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.Code
      .builder()
      .source(source.buildAwsValue())
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.Code.ReadOnly =
    zio.aws.codestar.model.Code.wrap(buildAwsValue())
}
object Code {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codestar.model.Code] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.Code =
      zio.aws.codestar.model.Code(source.asEditable, destination.asEditable)
    def source: zio.aws.codestar.model.CodeSource.ReadOnly
    def destination: zio.aws.codestar.model.CodeDestination.ReadOnly
    def getSource
        : ZIO[Any, Nothing, zio.aws.codestar.model.CodeSource.ReadOnly] =
      ZIO.succeed(source)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.codestar.model.CodeDestination.ReadOnly] =
      ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.Code
  ) extends zio.aws.codestar.model.Code.ReadOnly {
    override val source: zio.aws.codestar.model.CodeSource.ReadOnly =
      zio.aws.codestar.model.CodeSource.wrap(impl.source())
    override val destination: zio.aws.codestar.model.CodeDestination.ReadOnly =
      zio.aws.codestar.model.CodeDestination.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.Code
  ): zio.aws.codestar.model.Code.ReadOnly = new Wrapper(impl)
}
