package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  ProjectTemplateId,
  ClientRequestToken,
  ProjectArn,
  ProjectId
}
import scala.jdk.CollectionConverters._
final case class CreateProjectResponse(
    id: ProjectId,
    arn: ProjectArn,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    projectTemplateId: Optional[ProjectTemplateId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CreateProjectResponse
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .arn(ProjectArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        projectTemplateId.map(value =>
          ProjectTemplateId.unwrap(value): java.lang.String
        )
      )(_.projectTemplateId)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CreateProjectResponse.ReadOnly =
    zio.aws.codestar.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CreateProjectResponse =
      zio.aws.codestar.model.CreateProjectResponse(
        id,
        arn,
        clientRequestToken.map(value => value),
        projectTemplateId.map(value => value)
      )
    def id: ProjectId
    def arn: ProjectArn
    def clientRequestToken: Optional[ClientRequestToken]
    def projectTemplateId: Optional[ProjectTemplateId]
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(arn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getProjectTemplateId: ZIO[Any, AwsError, ProjectTemplateId] =
      AwsError.unwrapOptionField("projectTemplateId", projectTemplateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CreateProjectResponse
  ) extends zio.aws.codestar.model.CreateProjectResponse.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val arn: ProjectArn =
      zio.aws.codestar.model.primitives.ProjectArn(impl.arn())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.codestar.model.primitives.ClientRequestToken(value)
        )
    override val projectTemplateId: Optional[ProjectTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectTemplateId())
        .map(value =>
          zio.aws.codestar.model.primitives.ProjectTemplateId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CreateProjectResponse
  ): zio.aws.codestar.model.CreateProjectResponse.ReadOnly = new Wrapper(impl)
}
