package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.ProjectId
import scala.jdk.CollectionConverters._
final case class DescribeProjectRequest(id: ProjectId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DescribeProjectRequest = {
    import DescribeProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DescribeProjectRequest
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DescribeProjectRequest.ReadOnly =
    zio.aws.codestar.model.DescribeProjectRequest.wrap(buildAwsValue())
}
object DescribeProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DescribeProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DescribeProjectRequest =
      zio.aws.codestar.model.DescribeProjectRequest(id)
    def id: ProjectId
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DescribeProjectRequest
  ) extends zio.aws.codestar.model.DescribeProjectRequest.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DescribeProjectRequest
  ): zio.aws.codestar.model.DescribeProjectRequest.ReadOnly = new Wrapper(impl)
}
