package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.UserArn
import scala.jdk.CollectionConverters._
final case class DescribeUserProfileRequest(userArn: UserArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest = {
    import DescribeUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DescribeUserProfileRequest.ReadOnly =
    zio.aws.codestar.model.DescribeUserProfileRequest.wrap(buildAwsValue())
}
object DescribeUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DescribeUserProfileRequest =
      zio.aws.codestar.model.DescribeUserProfileRequest(userArn)
    def userArn: UserArn
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest
  ) extends zio.aws.codestar.model.DescribeUserProfileRequest.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest
  ): zio.aws.codestar.model.DescribeUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
