package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.{UserArn, ProjectId}
import scala.jdk.CollectionConverters._
final case class DisassociateTeamMemberRequest(
    projectId: ProjectId,
    userArn: UserArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest = {
    import DisassociateTeamMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest
      .builder()
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codestar.model.DisassociateTeamMemberRequest.ReadOnly =
    zio.aws.codestar.model.DisassociateTeamMemberRequest.wrap(buildAwsValue())
}
object DisassociateTeamMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DisassociateTeamMemberRequest =
      zio.aws.codestar.model.DisassociateTeamMemberRequest(projectId, userArn)
    def projectId: ProjectId
    def userArn: UserArn
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest
  ) extends zio.aws.codestar.model.DisassociateTeamMemberRequest.ReadOnly {
    override val projectId: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.projectId())
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest
  ): zio.aws.codestar.model.DisassociateTeamMemberRequest.ReadOnly =
    new Wrapper(impl)
}
