package zio.aws.codestar.model
import zio.aws.codestar.model.primitives.{
  MaxResults,
  PaginationToken,
  ProjectId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTeamMembersRequest(
    projectId: ProjectId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest = {
    import ListTeamMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest
      .builder()
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListTeamMembersRequest.ReadOnly =
    zio.aws.codestar.model.ListTeamMembersRequest.wrap(buildAwsValue())
}
object ListTeamMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListTeamMembersRequest =
      zio.aws.codestar.model.ListTeamMembersRequest(
        projectId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectId: ProjectId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest
  ) extends zio.aws.codestar.model.ListTeamMembersRequest.ReadOnly {
    override val projectId: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.projectId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codestar.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest
  ): zio.aws.codestar.model.ListTeamMembersRequest.ReadOnly = new Wrapper(impl)
}
