package zio.aws.codestar
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.codestar.model.primitives.{
  TemplateParameterValue,
  TemplateParameterKey,
  TagValue,
  TagKey
}
import zio.aws.codestar.model.primitives.ProjectDescription.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object BucketKey extends Subtype[String]
    type BucketKey = zio.aws.codestar.model.primitives.BucketKey.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.codestar.model.primitives.BucketName.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.codestar.model.primitives.ClientRequestToken.Type
    object CreatedTimestamp extends Subtype[Instant]
    type CreatedTimestamp =
      zio.aws.codestar.model.primitives.CreatedTimestamp.Type
    object DeleteStack extends Subtype[Boolean]
    type DeleteStack = zio.aws.codestar.model.primitives.DeleteStack.Type
    object Email extends Subtype[String]
    type Email = zio.aws.codestar.model.primitives.Email.Type
    object GitHubPersonalToken extends Subtype[String]
    type GitHubPersonalToken =
      zio.aws.codestar.model.primitives.GitHubPersonalToken.Type
    object LastModifiedTimestamp extends Subtype[Instant]
    type LastModifiedTimestamp =
      zio.aws.codestar.model.primitives.LastModifiedTimestamp.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.codestar.model.primitives.MaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.codestar.model.primitives.PaginationToken.Type
    object ProjectArn extends Subtype[String]
    type ProjectArn = zio.aws.codestar.model.primitives.ProjectArn.Type
    object ProjectDescription extends Subtype[String]
    type ProjectDescription =
      zio.aws.codestar.model.primitives.ProjectDescription.Type
    object ProjectId extends Subtype[String]
    type ProjectId = zio.aws.codestar.model.primitives.ProjectId.Type
    object ProjectName extends Subtype[String]
    type ProjectName = zio.aws.codestar.model.primitives.ProjectName.Type
    object ProjectTemplateId extends Subtype[String]
    type ProjectTemplateId =
      zio.aws.codestar.model.primitives.ProjectTemplateId.Type
    object Reason extends Subtype[String]
    type Reason = zio.aws.codestar.model.primitives.Reason.Type
    object RemoteAccessAllowed extends Subtype[Boolean]
    type RemoteAccessAllowed =
      zio.aws.codestar.model.primitives.RemoteAccessAllowed.Type
    object RepositoryDescription extends Subtype[String]
    type RepositoryDescription =
      zio.aws.codestar.model.primitives.RepositoryDescription.Type
    object RepositoryEnableIssues extends Subtype[Boolean]
    type RepositoryEnableIssues =
      zio.aws.codestar.model.primitives.RepositoryEnableIssues.Type
    object RepositoryIsPrivate extends Subtype[Boolean]
    type RepositoryIsPrivate =
      zio.aws.codestar.model.primitives.RepositoryIsPrivate.Type
    object RepositoryName extends Subtype[String]
    type RepositoryName = zio.aws.codestar.model.primitives.RepositoryName.Type
    object RepositoryOwner extends Subtype[String]
    type RepositoryOwner =
      zio.aws.codestar.model.primitives.RepositoryOwner.Type
    object RepositoryType extends Subtype[String]
    type RepositoryType = zio.aws.codestar.model.primitives.RepositoryType.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.codestar.model.primitives.ResourceId.Type
    object Role extends Subtype[String]
    type Role = zio.aws.codestar.model.primitives.Role.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.codestar.model.primitives.RoleArn.Type
    object SshPublicKey extends Subtype[String]
    type SshPublicKey = zio.aws.codestar.model.primitives.SshPublicKey.Type
    object StackId extends Subtype[String]
    type StackId = zio.aws.codestar.model.primitives.StackId.Type
    object State extends Subtype[String]
    type State = zio.aws.codestar.model.primitives.State.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codestar.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codestar.model.primitives.TagValue.Type
    object TemplateParameterKey extends Subtype[String]
    type TemplateParameterKey =
      zio.aws.codestar.model.primitives.TemplateParameterKey.Type
    object TemplateParameterValue extends Subtype[String]
    type TemplateParameterValue =
      zio.aws.codestar.model.primitives.TemplateParameterValue.Type
    object UserArn extends Subtype[String]
    type UserArn = zio.aws.codestar.model.primitives.UserArn.Type
    object UserProfileDisplayName extends Subtype[String]
    type UserProfileDisplayName =
      zio.aws.codestar.model.primitives.UserProfileDisplayName.Type
  }
  type ProjectsList = List[zio.aws.codestar.model.ProjectSummary]
  type ResourcesResult = List[zio.aws.codestar.model.Resource]
  type SourceCode = List[zio.aws.codestar.model.Code]
  type TagKeys = List[TagKey]
  type Tags = Map[TagKey, TagValue]
  type TeamMemberResult = List[zio.aws.codestar.model.TeamMember]
  type TemplateParameterMap = Map[TemplateParameterKey, TemplateParameterValue]
  type UserProfilesList = List[zio.aws.codestar.model.UserProfileSummary]
}
