package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListUserProfilesResponse(
    userProfiles: Iterable[zio.aws.codestar.model.UserProfileSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListUserProfilesResponse = {
    import ListUserProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListUserProfilesResponse
      .builder()
      .userProfiles(userProfiles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly =
    zio.aws.codestar.model.ListUserProfilesResponse.wrap(buildAwsValue())
}
object ListUserProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListUserProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListUserProfilesResponse =
      zio.aws.codestar.model.ListUserProfilesResponse(
        userProfiles.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def userProfiles: List[zio.aws.codestar.model.UserProfileSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getUserProfiles: ZIO[Any, Nothing, List[
      zio.aws.codestar.model.UserProfileSummary.ReadOnly
    ]] = ZIO.succeed(userProfiles)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListUserProfilesResponse
  ) extends zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly {
    override val userProfiles
        : List[zio.aws.codestar.model.UserProfileSummary.ReadOnly] = impl
      .userProfiles()
      .asScala
      .map { item =>
        zio.aws.codestar.model.UserProfileSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListUserProfilesResponse
  ): zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
