package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.{TagValue, TagKey, ProjectId}
import scala.jdk.CollectionConverters._
final case class TagProjectRequest(id: ProjectId, tags: Map[TagKey, TagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.TagProjectRequest = {
    import TagProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.TagProjectRequest
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.TagProjectRequest.ReadOnly =
    zio.aws.codestar.model.TagProjectRequest.wrap(buildAwsValue())
}
object TagProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.TagProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.TagProjectRequest =
      zio.aws.codestar.model.TagProjectRequest(id, tags)
    def id: ProjectId
    def tags: Map[TagKey, TagValue]
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.TagProjectRequest
  ) extends zio.aws.codestar.model.TagProjectRequest.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.codestar.model.primitives
          .TagKey(key) -> zio.aws.codestar.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.TagProjectRequest
  ): zio.aws.codestar.model.TagProjectRequest.ReadOnly = new Wrapper(impl)
}
