package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  RemoteAccessAllowed,
  Role,
  UserArn,
  ProjectId
}
import scala.jdk.CollectionConverters._
final case class UpdateTeamMemberRequest(
    projectId: ProjectId,
    userArn: UserArn,
    projectRole: Optional[Role] = Optional.Absent,
    remoteAccessAllowed: Optional[RemoteAccessAllowed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest = {
    import UpdateTeamMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest
      .builder()
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .optionallyWith(
        projectRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.projectRole)
      .optionallyWith(
        remoteAccessAllowed.map(value =>
          RemoteAccessAllowed.unwrap(value): java.lang.Boolean
        )
      )(_.remoteAccessAllowed)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UpdateTeamMemberRequest.ReadOnly =
    zio.aws.codestar.model.UpdateTeamMemberRequest.wrap(buildAwsValue())
}
object UpdateTeamMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UpdateTeamMemberRequest =
      zio.aws.codestar.model.UpdateTeamMemberRequest(
        projectId,
        userArn,
        projectRole.map(value => value),
        remoteAccessAllowed.map(value => value)
      )
    def projectId: ProjectId
    def userArn: UserArn
    def projectRole: Optional[Role]
    def remoteAccessAllowed: Optional[RemoteAccessAllowed]
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getProjectRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("projectRole", projectRole)
    def getRemoteAccessAllowed: ZIO[Any, AwsError, RemoteAccessAllowed] =
      AwsError.unwrapOptionField("remoteAccessAllowed", remoteAccessAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest
  ) extends zio.aws.codestar.model.UpdateTeamMemberRequest.ReadOnly {
    override val projectId: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.projectId())
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val projectRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.projectRole())
      .map(value => zio.aws.codestar.model.primitives.Role(value))
    override val remoteAccessAllowed: Optional[RemoteAccessAllowed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccessAllowed())
        .map(value =>
          zio.aws.codestar.model.primitives.RemoteAccessAllowed(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest
  ): zio.aws.codestar.model.UpdateTeamMemberRequest.ReadOnly = new Wrapper(impl)
}
