package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  SshPublicKey,
  Email,
  UserProfileDisplayName,
  UserArn
}
import scala.jdk.CollectionConverters._
final case class UpdateUserProfileRequest(
    userArn: UserArn,
    displayName: Optional[UserProfileDisplayName] = Optional.Absent,
    emailAddress: Optional[Email] = Optional.Absent,
    sshPublicKey: Optional[SshPublicKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest = {
    import UpdateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          UserProfileDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UpdateUserProfileRequest.ReadOnly =
    zio.aws.codestar.model.UpdateUserProfileRequest.wrap(buildAwsValue())
}
object UpdateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UpdateUserProfileRequest =
      zio.aws.codestar.model.UpdateUserProfileRequest(
        userArn,
        displayName.map(value => value),
        emailAddress.map(value => value),
        sshPublicKey.map(value => value)
      )
    def userArn: UserArn
    def displayName: Optional[UserProfileDisplayName]
    def emailAddress: Optional[Email]
    def sshPublicKey: Optional[SshPublicKey]
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getDisplayName: ZIO[Any, AwsError, UserProfileDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
  ) extends zio.aws.codestar.model.UpdateUserProfileRequest.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val displayName: Optional[UserProfileDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.codestar.model.primitives.UserProfileDisplayName(value)
        )
    override val emailAddress: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.codestar.model.primitives.Email(value))
    override val sshPublicKey: Optional[SshPublicKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sshPublicKey())
      .map(value => zio.aws.codestar.model.primitives.SshPublicKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
  ): zio.aws.codestar.model.UpdateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
