package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.UserArn
import scala.jdk.CollectionConverters._
final case class DeleteUserProfileResponse(userArn: UserArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DeleteUserProfileResponse = {
    import DeleteUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DeleteUserProfileResponse
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly =
    zio.aws.codestar.model.DeleteUserProfileResponse.wrap(buildAwsValue())
}
object DeleteUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DeleteUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DeleteUserProfileResponse =
      zio.aws.codestar.model.DeleteUserProfileResponse(userArn)
    def userArn: UserArn
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DeleteUserProfileResponse
  ) extends zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DeleteUserProfileResponse
  ): zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
