package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  TemplateParameterValue,
  TemplateParameterKey,
  RoleArn
}
import scala.jdk.CollectionConverters._
final case class Toolchain(
    source: zio.aws.codestar.model.ToolchainSource,
    roleArn: Optional[RoleArn] = Optional.Absent,
    stackParameters: Optional[
      Map[TemplateParameterKey, TemplateParameterValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.Toolchain = {
    import Toolchain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.Toolchain
      .builder()
      .source(source.buildAwsValue())
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        stackParameters.map(value =>
          value
            .map({ case (key, value) =>
              (TemplateParameterKey
                .unwrap(key): java.lang.String) -> (TemplateParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stackParameters)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.Toolchain.ReadOnly =
    zio.aws.codestar.model.Toolchain.wrap(buildAwsValue())
}
object Toolchain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.Toolchain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.Toolchain =
      zio.aws.codestar.model.Toolchain(
        source.asEditable,
        roleArn.map(value => value),
        stackParameters.map(value => value)
      )
    def source: zio.aws.codestar.model.ToolchainSource.ReadOnly
    def roleArn: Optional[RoleArn]
    def stackParameters
        : Optional[Map[TemplateParameterKey, TemplateParameterValue]]
    def getSource
        : ZIO[Any, Nothing, zio.aws.codestar.model.ToolchainSource.ReadOnly] =
      ZIO.succeed(source)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStackParameters: ZIO[Any, AwsError, Map[
      TemplateParameterKey,
      TemplateParameterValue
    ]] = AwsError.unwrapOptionField("stackParameters", stackParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.Toolchain
  ) extends zio.aws.codestar.model.Toolchain.ReadOnly {
    override val source: zio.aws.codestar.model.ToolchainSource.ReadOnly =
      zio.aws.codestar.model.ToolchainSource.wrap(impl.source())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.codestar.model.primitives.RoleArn(value))
    override val stackParameters
        : Optional[Map[TemplateParameterKey, TemplateParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codestar.model.primitives
                .TemplateParameterKey(key) -> zio.aws.codestar.model.primitives
                .TemplateParameterValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.Toolchain
  ): zio.aws.codestar.model.Toolchain.ReadOnly = new Wrapper(impl)
}
