package zio.aws.config
import zio.aws.config.model.DeleteStoredQueryResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.config.model.{
  AggregateConformancePackComplianceSummary,
  PutConfigRuleResponse,
  DeleteConfigurationAggregatorRequest,
  PutRemediationConfigurationsRequest,
  GetAggregateConfigRuleComplianceSummaryRequest,
  DeleteConfigurationAggregatorResponse,
  AggregateComplianceByConformancePack,
  OrganizationConfigRule,
  DescribeRemediationExceptionsRequest,
  PutStoredQueryResponse,
  PendingAggregationRequest,
  GetConformancePackComplianceDetailsRequest,
  DescribeComplianceByConfigRuleRequest,
  DescribeDeliveryChannelStatusResponse,
  DeleteStoredQueryRequest,
  OrganizationConformancePackDetailedStatus,
  OrganizationConfigRuleStatus,
  GetComplianceSummaryByResourceTypeResponse,
  DescribeConformancePacksRequest,
  DescribeConfigurationAggregatorsResponse,
  AggregateComplianceByConfigRule,
  DescribeAggregateComplianceByConfigRulesRequest,
  AggregateEvaluationResult,
  ComplianceByConfigRule,
  StoredQueryMetadata,
  ListAggregateDiscoveredResourcesRequest,
  PutAggregationAuthorizationResponse,
  DescribeRemediationConfigurationsResponse,
  EvaluationResult,
  GetResourceEvaluationSummaryRequest,
  PutRetentionConfigurationResponse,
  DeleteRemediationExceptionsRequest,
  DescribeConformancePackComplianceRequest,
  GetDiscoveredResourceCountsRequest,
  DescribeConfigurationRecordersResponse,
  DescribeOrganizationConformancePackStatusesRequest,
  StopConfigurationRecorderRequest,
  PutExternalEvaluationRequest,
  GetAggregateComplianceDetailsByConfigRuleRequest,
  DeleteRemediationConfigurationRequest,
  PutConformancePackRequest,
  DeleteRetentionConfigurationResponse,
  SelectAggregateResourceConfigRequest,
  DescribeAggregateComplianceByConformancePacksResponse,
  DescribeOrganizationConfigRuleStatusesResponse,
  GetOrganizationConformancePackDetailedStatusRequest,
  DescribeConfigRuleEvaluationStatusRequest,
  GetAggregateConformancePackComplianceSummaryRequest,
  PutRemediationExceptionsResponse,
  DescribeRetentionConfigurationsResponse,
  BatchGetResourceConfigRequest,
  PutEvaluationsResponse,
  GetConformancePackComplianceSummaryResponse,
  ConformancePackComplianceScore,
  ListStoredQueriesRequest,
  DescribeConfigRulesResponse,
  PutOrganizationConfigRuleRequest,
  PutOrganizationConfigRuleResponse,
  DescribeOrganizationConformancePacksRequest,
  BatchGetAggregateResourceConfigResponse,
  RetentionConfiguration,
  DescribeOrganizationConfigRulesResponse,
  DescribeConfigurationRecorderStatusRequest,
  GetComplianceDetailsByResourceResponse,
  GetComplianceSummaryByConfigRuleResponse,
  DescribeRemediationExecutionStatusResponse,
  GetComplianceDetailsByResourceRequest,
  RemediationExecutionStatus,
  DeleteEvaluationResultsResponse,
  ConformancePackEvaluationResult,
  GetAggregateResourceConfigResponse,
  GetResourceEvaluationSummaryResponse,
  DeleteDeliveryChannelResponse,
  AggregatedSourceStatus,
  StopConfigurationRecorderResponse,
  DescribeConfigRulesRequest,
  AggregationAuthorization,
  DeleteAggregationAuthorizationResponse,
  ListTagsForResourceRequest,
  Tag,
  DescribeRemediationExecutionStatusRequest,
  PutConfigRuleRequest,
  SelectAggregateResourceConfigResponse,
  ListAggregateDiscoveredResourcesResponse,
  DescribeRetentionConfigurationsRequest,
  DeleteOrganizationConformancePackResponse,
  GetComplianceSummaryByResourceTypeRequest,
  DeleteOrganizationConformancePackRequest,
  DescribeRemediationExceptionsResponse,
  ListDiscoveredResourcesResponse,
  OrganizationConformancePackStatus,
  DeletePendingAggregationRequestResponse,
  DescribeComplianceByResourceRequest,
  GetAggregateConfigRuleComplianceSummaryResponse,
  DescribeOrganizationConformancePacksResponse,
  GetOrganizationConfigRuleDetailedStatusResponse,
  DescribeDeliveryChannelStatusRequest,
  DescribeConfigurationRecordersRequest,
  DeleteConfigRuleResponse,
  DeleteRemediationConfigurationResponse,
  StartRemediationExecutionRequest,
  DescribeAggregationAuthorizationsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetOrganizationConfigRuleDetailedStatusRequest,
  MemberAccountStatus,
  DescribeConfigurationAggregatorSourcesStatusResponse,
  ConformancePackComplianceSummary,
  DescribeAggregateComplianceByConfigRulesResponse,
  PutResourceConfigRequest,
  AggregateResourceIdentifier,
  DeleteConformancePackRequest,
  DeleteAggregationAuthorizationRequest,
  GetAggregateConformancePackComplianceSummaryResponse,
  DeleteEvaluationResultsRequest,
  ResourceIdentifier,
  DescribeConfigurationAggregatorsRequest,
  PutExternalEvaluationResponse,
  GetComplianceDetailsByConfigRuleRequest,
  PutEvaluationsRequest,
  ComplianceByResource,
  DescribeConformancePackComplianceResponse,
  StartRemediationExecutionResponse,
  GroupedResourceCount,
  DescribeComplianceByResourceResponse,
  ListConformancePackComplianceScoresRequest,
  GetComplianceDetailsByConfigRuleResponse,
  DescribeConformancePackStatusRequest,
  ListConformancePackComplianceScoresResponse,
  GetOrganizationCustomRulePolicyResponse,
  DeleteOrganizationConfigRuleResponse,
  DescribeAggregationAuthorizationsRequest,
  ListDiscoveredResourcesRequest,
  PutConformancePackResponse,
  DeleteStoredQueryResponse,
  GetAggregateComplianceDetailsByConfigRuleResponse,
  DescribeComplianceByConfigRuleResponse,
  GetAggregateResourceConfigRequest,
  ResourceEvaluation,
  GetStoredQueryResponse,
  RemediationException,
  DeleteResourceConfigRequest,
  DeleteDeliveryChannelRequest,
  PutRemediationExceptionsRequest,
  DescribeOrganizationConfigRulesRequest,
  PutConfigurationRecorderRequest,
  GetResourceConfigHistoryResponse,
  GetResourceConfigHistoryRequest,
  StartConfigRulesEvaluationRequest,
  DeliverConfigSnapshotRequest,
  GetOrganizationConformancePackDetailedStatusResponse,
  ListResourceEvaluationsRequest,
  GetCustomRulePolicyResponse,
  UntagResourceRequest,
  PutConfigurationAggregatorResponse,
  ListStoredQueriesResponse,
  PutOrganizationConformancePackResponse,
  StartConfigurationRecorderRequest,
  PutOrganizationConformancePackRequest,
  PutAggregationAuthorizationRequest,
  StartResourceEvaluationResponse,
  DeleteRetentionConfigurationRequest,
  DescribeConfigurationAggregatorSourcesStatusRequest,
  GetOrganizationCustomRulePolicyRequest,
  OrganizationConformancePack,
  GetCustomRulePolicyRequest,
  StartConfigurationRecorderResponse,
  DeleteConformancePackResponse,
  GetAggregateDiscoveredResourceCountsRequest,
  GetDiscoveredResourceCountsResponse,
  ConformancePackStatusDetail,
  GetStoredQueryRequest,
  DescribeRemediationConfigurationsRequest,
  DescribeDeliveryChannelsRequest,
  DeletePendingAggregationRequestRequest,
  PutRetentionConfigurationRequest,
  SelectResourceConfigResponse,
  ConfigRule,
  DescribeAggregateComplianceByConformancePacksRequest,
  PutStoredQueryRequest,
  PutResourceConfigResponse,
  DescribeConfigurationRecorderStatusResponse,
  StartResourceEvaluationRequest,
  GetConformancePackComplianceDetailsResponse,
  ConfigurationItem,
  DeleteConfigurationRecorderResponse,
  GetAggregateDiscoveredResourceCountsResponse,
  ConformancePackDetail,
  ConfigRuleEvaluationStatus,
  GetComplianceSummaryByConfigRuleRequest,
  DescribeDeliveryChannelsResponse,
  PutRemediationConfigurationsResponse,
  DeleteOrganizationConfigRuleRequest,
  BatchGetResourceConfigResponse,
  StartConfigRulesEvaluationResponse,
  TagResourceResponse,
  PutConfigurationRecorderResponse,
  DescribeOrganizationConfigRuleStatusesRequest,
  DescribeConformancePackStatusResponse,
  GetConformancePackComplianceSummaryRequest,
  DescribeOrganizationConformancePackStatusesResponse,
  DescribePendingAggregationRequestsResponse,
  BatchGetAggregateResourceConfigRequest,
  DeleteConfigRuleRequest,
  DeleteRemediationExceptionsResponse,
  PutConfigurationAggregatorRequest,
  ConformancePackRuleCompliance,
  DeliverConfigSnapshotResponse,
  SelectResourceConfigRequest,
  TagResourceRequest,
  PutDeliveryChannelResponse,
  ConfigurationAggregator,
  DeleteConfigurationRecorderRequest,
  ListResourceEvaluationsResponse,
  AggregateComplianceCount,
  DescribeConfigRuleEvaluationStatusResponse,
  DescribeConformancePacksResponse,
  DescribePendingAggregationRequestsRequest,
  PutDeliveryChannelRequest,
  DeleteResourceConfigResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.config.paginators.{
  ListDiscoveredResourcesPublisher,
  GetResourceConfigHistoryPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.config.{
  ConfigAsyncClientBuilder,
  ConfigAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Config extends AspectSupport[Config] {
  val api: ConfigAsyncClient
  def getResourceEvaluationSummary(
      request: zio.aws.config.model.GetResourceEvaluationSummaryRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetResourceEvaluationSummaryResponse.ReadOnly
  ]
  def deleteRemediationExceptions(
      request: zio.aws.config.model.DeleteRemediationExceptionsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly
  ]
  def describeComplianceByConfigRule(
      request: zio.aws.config.model.DescribeComplianceByConfigRuleRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.ComplianceByConfigRule.ReadOnly
  ]
  def describeComplianceByConfigRulePaginated(
      request: zio.aws.config.model.DescribeComplianceByConfigRuleRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly
  ]
  def putConfigurationAggregator(
      request: zio.aws.config.model.PutConfigurationAggregatorRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly
  ]
  def getComplianceSummaryByConfigRule(): IO[
    AwsError,
    zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly
  ]
  def getAggregateConfigRuleComplianceSummary(
      request: zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly,
    zio.aws.config.model.AggregateComplianceCount.ReadOnly
  ]]
  def getAggregateConfigRuleComplianceSummaryPaginated(
      request: zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly
  ]
  def describeDeliveryChannelStatus(
      request: zio.aws.config.model.DescribeDeliveryChannelStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly
  ]
  def describeAggregationAuthorizations(
      request: zio.aws.config.model.DescribeAggregationAuthorizationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.AggregationAuthorization.ReadOnly
  ]
  def describeAggregationAuthorizationsPaginated(
      request: zio.aws.config.model.DescribeAggregationAuthorizationsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly
  ]
  def getOrganizationConfigRuleDetailedStatus(
      request: zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.MemberAccountStatus.ReadOnly]
  def getOrganizationConfigRuleDetailedStatusPaginated(
      request: zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly
  ]
  def startConfigRulesEvaluation(
      request: zio.aws.config.model.StartConfigRulesEvaluationRequest
  ): IO[
    AwsError,
    zio.aws.config.model.StartConfigRulesEvaluationResponse.ReadOnly
  ]
  def describeOrganizationConfigRuleStatuses(
      request: zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
  ]
  def describeOrganizationConfigRuleStatusesPaginated(
      request: zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly
  ]
  def stopConfigurationRecorder(
      request: zio.aws.config.model.StopConfigurationRecorderRequest
  ): IO[AwsError, Unit]
  def putConfigurationRecorder(
      request: zio.aws.config.model.PutConfigurationRecorderRequest
  ): IO[AwsError, Unit]
  def deleteOrganizationConformancePack(
      request: zio.aws.config.model.DeleteOrganizationConformancePackRequest
  ): IO[AwsError, Unit]
  def describeConfigRuleEvaluationStatus(
      request: zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
  ]
  def describeConfigRuleEvaluationStatusPaginated(
      request: zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly
  ]
  def describeOrganizationConformancePackStatuses(
      request: zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly
  ]
  def describeOrganizationConformancePackStatusesPaginated(
      request: zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly
  ]
  def describeConfigurationAggregators(
      request: zio.aws.config.model.DescribeConfigurationAggregatorsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.ConfigurationAggregator.ReadOnly
  ]
  def describeConfigurationAggregatorsPaginated(
      request: zio.aws.config.model.DescribeConfigurationAggregatorsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly
  ]
  def describeDeliveryChannels(
      request: zio.aws.config.model.DescribeDeliveryChannelsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly
  ]
  def deleteOrganizationConfigRule(
      request: zio.aws.config.model.DeleteOrganizationConfigRuleRequest
  ): IO[AwsError, Unit]
  def putDeliveryChannel(
      request: zio.aws.config.model.PutDeliveryChannelRequest
  ): IO[AwsError, Unit]
  def listAggregateDiscoveredResources(
      request: zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
  ]
  def listAggregateDiscoveredResourcesPaginated(
      request: zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
  ): IO[
    AwsError,
    zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly
  ]
  def describePendingAggregationRequests(
      request: zio.aws.config.model.DescribePendingAggregationRequestsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.PendingAggregationRequest.ReadOnly
  ]
  def describePendingAggregationRequestsPaginated(
      request: zio.aws.config.model.DescribePendingAggregationRequestsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly
  ]
  def describeAggregateComplianceByConfigRules(
      request: zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly
  ]
  def describeAggregateComplianceByConfigRulesPaginated(
      request: zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly
  ]
  def deleteEvaluationResults(
      request: zio.aws.config.model.DeleteEvaluationResultsRequest
  ): IO[AwsError, zio.aws.config.model.DeleteEvaluationResultsResponse.ReadOnly]
  def describeRemediationConfigurations(
      request: zio.aws.config.model.DescribeRemediationConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly
  ]
  def getComplianceDetailsByResource(
      request: zio.aws.config.model.GetComplianceDetailsByResourceRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.EvaluationResult.ReadOnly]
  def getComplianceDetailsByResourcePaginated(
      request: zio.aws.config.model.GetComplianceDetailsByResourceRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly
  ]
  def describeRemediationExceptions(
      request: zio.aws.config.model.DescribeRemediationExceptionsRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.RemediationException.ReadOnly]
  def describeRemediationExceptionsPaginated(
      request: zio.aws.config.model.DescribeRemediationExceptionsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly
  ]
  def listStoredQueries(
      request: zio.aws.config.model.ListStoredQueriesRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.StoredQueryMetadata.ReadOnly]
  def listStoredQueriesPaginated(
      request: zio.aws.config.model.ListStoredQueriesRequest
  ): IO[AwsError, zio.aws.config.model.ListStoredQueriesResponse.ReadOnly]
  def deleteResourceConfig(
      request: zio.aws.config.model.DeleteResourceConfigRequest
  ): IO[AwsError, Unit]
  def putRemediationExceptions(
      request: zio.aws.config.model.PutRemediationExceptionsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly
  ]
  def deleteConformancePack(
      request: zio.aws.config.model.DeleteConformancePackRequest
  ): IO[AwsError, Unit]
  def deleteRetentionConfiguration(
      request: zio.aws.config.model.DeleteRetentionConfigurationRequest
  ): IO[AwsError, Unit]
  def putExternalEvaluation(
      request: zio.aws.config.model.PutExternalEvaluationRequest
  ): IO[AwsError, zio.aws.config.model.PutExternalEvaluationResponse.ReadOnly]
  def getConformancePackComplianceSummary(
      request: zio.aws.config.model.GetConformancePackComplianceSummaryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly
  ]
  def getConformancePackComplianceSummaryPaginated(
      request: zio.aws.config.model.GetConformancePackComplianceSummaryRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly
  ]
  def deleteConfigRule(
      request: zio.aws.config.model.DeleteConfigRuleRequest
  ): IO[AwsError, Unit]
  def describeConfigurationRecorders(
      request: zio.aws.config.model.DescribeConfigurationRecordersRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly
  ]
  def selectAggregateResourceConfig(
      request: zio.aws.config.model.SelectAggregateResourceConfigRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly,
    String
  ]]
  def selectAggregateResourceConfigPaginated(
      request: zio.aws.config.model.SelectAggregateResourceConfigRequest
  ): IO[
    AwsError,
    zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly
  ]
  def describeOrganizationConformancePacks(
      request: zio.aws.config.model.DescribeOrganizationConformancePacksRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.OrganizationConformancePack.ReadOnly
  ]
  def describeOrganizationConformancePacksPaginated(
      request: zio.aws.config.model.DescribeOrganizationConformancePacksRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly
  ]
  def getStoredQuery(
      request: zio.aws.config.model.GetStoredQueryRequest
  ): IO[AwsError, zio.aws.config.model.GetStoredQueryResponse.ReadOnly]
  def deletePendingAggregationRequest(
      request: zio.aws.config.model.DeletePendingAggregationRequestRequest
  ): IO[AwsError, Unit]
  def getCustomRulePolicy(
      request: zio.aws.config.model.GetCustomRulePolicyRequest
  ): IO[AwsError, zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly]
  def startConfigurationRecorder(
      request: zio.aws.config.model.StartConfigurationRecorderRequest
  ): IO[AwsError, Unit]
  def putStoredQuery(
      request: zio.aws.config.model.PutStoredQueryRequest
  ): IO[AwsError, zio.aws.config.model.PutStoredQueryResponse.ReadOnly]
  def getComplianceSummaryByResourceType(
      request: zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly
  ]
  def describeConfigRules(
      request: zio.aws.config.model.DescribeConfigRulesRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.ConfigRule.ReadOnly]
  def describeConfigRulesPaginated(
      request: zio.aws.config.model.DescribeConfigRulesRequest
  ): IO[AwsError, zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly]
  def describeConformancePacks(
      request: zio.aws.config.model.DescribeConformancePacksRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.ConformancePackDetail.ReadOnly]
  def describeConformancePacksPaginated(
      request: zio.aws.config.model.DescribeConformancePacksRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly
  ]
  def getAggregateResourceConfig(
      request: zio.aws.config.model.GetAggregateResourceConfigRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly
  ]
  def getAggregateDiscoveredResourceCounts(
      request: zio.aws.config.model.GetAggregateDiscoveredResourceCountsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly,
    zio.aws.config.model.GroupedResourceCount.ReadOnly
  ]]
  def getAggregateDiscoveredResourceCountsPaginated(
      request: zio.aws.config.model.GetAggregateDiscoveredResourceCountsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly
  ]
  def describeConformancePackCompliance(
      request: zio.aws.config.model.DescribeConformancePackComplianceRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly,
    zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly
  ]]
  def describeConformancePackCompliancePaginated(
      request: zio.aws.config.model.DescribeConformancePackComplianceRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly
  ]
  def describeComplianceByResource(
      request: zio.aws.config.model.DescribeComplianceByResourceRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.ComplianceByResource.ReadOnly]
  def describeComplianceByResourcePaginated(
      request: zio.aws.config.model.DescribeComplianceByResourceRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly
  ]
  def putRemediationConfigurations(
      request: zio.aws.config.model.PutRemediationConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.config.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def describeAggregateComplianceByConformancePacks(
      request: zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly
  ]
  def describeAggregateComplianceByConformancePacksPaginated(
      request: zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly
  ]
  def getResourceConfigHistory(
      request: zio.aws.config.model.GetResourceConfigHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.ConfigurationItem.ReadOnly]
  def getResourceConfigHistoryPaginated(
      request: zio.aws.config.model.GetResourceConfigHistoryRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly
  ]
  def describeRetentionConfigurations(
      request: zio.aws.config.model.DescribeRetentionConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.RetentionConfiguration.ReadOnly
  ]
  def describeRetentionConfigurationsPaginated(
      request: zio.aws.config.model.DescribeRetentionConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly
  ]
  def putOrganizationConformancePack(
      request: zio.aws.config.model.PutOrganizationConformancePackRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly
  ]
  def listConformancePackComplianceScores(
      request: zio.aws.config.model.ListConformancePackComplianceScoresRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.ConformancePackComplianceScore.ReadOnly
  ]
  def listConformancePackComplianceScoresPaginated(
      request: zio.aws.config.model.ListConformancePackComplianceScoresRequest
  ): IO[
    AwsError,
    zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly
  ]
  def putOrganizationConfigRule(
      request: zio.aws.config.model.PutOrganizationConfigRuleRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly
  ]
  def putResourceConfig(
      request: zio.aws.config.model.PutResourceConfigRequest
  ): IO[AwsError, Unit]
  def describeConfigurationAggregatorSourcesStatus(
      request: zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.AggregatedSourceStatus.ReadOnly
  ]
  def describeConfigurationAggregatorSourcesStatusPaginated(
      request: zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly
  ]
  def deleteConfigurationAggregator(
      request: zio.aws.config.model.DeleteConfigurationAggregatorRequest
  ): IO[AwsError, Unit]
  def describeConformancePackStatus(
      request: zio.aws.config.model.DescribeConformancePackStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.ConformancePackStatusDetail.ReadOnly
  ]
  def describeConformancePackStatusPaginated(
      request: zio.aws.config.model.DescribeConformancePackStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly
  ]
  def putConformancePack(
      request: zio.aws.config.model.PutConformancePackRequest
  ): IO[AwsError, zio.aws.config.model.PutConformancePackResponse.ReadOnly]
  def deleteAggregationAuthorization(
      request: zio.aws.config.model.DeleteAggregationAuthorizationRequest
  ): IO[AwsError, Unit]
  def startResourceEvaluation(
      request: zio.aws.config.model.StartResourceEvaluationRequest
  ): IO[AwsError, zio.aws.config.model.StartResourceEvaluationResponse.ReadOnly]
  def putEvaluations(
      request: zio.aws.config.model.PutEvaluationsRequest
  ): IO[AwsError, zio.aws.config.model.PutEvaluationsResponse.ReadOnly]
  def deleteDeliveryChannel(
      request: zio.aws.config.model.DeleteDeliveryChannelRequest
  ): IO[AwsError, Unit]
  def putConfigRule(
      request: zio.aws.config.model.PutConfigRuleRequest
  ): IO[AwsError, Unit]
  def listTagsForResource(
      request: zio.aws.config.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.config.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.config.model.ListTagsForResourceResponse.ReadOnly]
  def getOrganizationConformancePackDetailedStatus(
      request: zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
  ]
  def getOrganizationConformancePackDetailedStatusPaginated(
      request: zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.config.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def deleteStoredQuery(
      request: zio.aws.config.model.DeleteStoredQueryRequest
  ): IO[AwsError, ReadOnly]
  def getComplianceDetailsByConfigRule(
      request: zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.EvaluationResult.ReadOnly]
  def getComplianceDetailsByConfigRulePaginated(
      request: zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly
  ]
  def startRemediationExecution(
      request: zio.aws.config.model.StartRemediationExecutionRequest
  ): IO[
    AwsError,
    zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly
  ]
  def getConformancePackComplianceDetails(
      request: zio.aws.config.model.GetConformancePackComplianceDetailsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly,
    zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly
  ]]
  def getConformancePackComplianceDetailsPaginated(
      request: zio.aws.config.model.GetConformancePackComplianceDetailsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly
  ]
  def selectResourceConfig(
      request: zio.aws.config.model.SelectResourceConfigRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.SelectResourceConfigResponse.ReadOnly,
    String
  ]]
  def selectResourceConfigPaginated(
      request: zio.aws.config.model.SelectResourceConfigRequest
  ): IO[AwsError, zio.aws.config.model.SelectResourceConfigResponse.ReadOnly]
  def describeRemediationExecutionStatus(
      request: zio.aws.config.model.DescribeRemediationExecutionStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.RemediationExecutionStatus.ReadOnly
  ]
  def describeRemediationExecutionStatusPaginated(
      request: zio.aws.config.model.DescribeRemediationExecutionStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly
  ]
  def describeConfigurationRecorderStatus(
      request: zio.aws.config.model.DescribeConfigurationRecorderStatusRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly
  ]
  def getOrganizationCustomRulePolicy(
      request: zio.aws.config.model.GetOrganizationCustomRulePolicyRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly
  ]
  def getAggregateComplianceDetailsByConfigRule(
      request: zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.AggregateEvaluationResult.ReadOnly
  ]
  def getAggregateComplianceDetailsByConfigRulePaginated(
      request: zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly
  ]
  def putAggregationAuthorization(
      request: zio.aws.config.model.PutAggregationAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly
  ]
  def getAggregateConformancePackComplianceSummary(
      request: zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly,
    zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
  ]]
  def getAggregateConformancePackComplianceSummaryPaginated(
      request: zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly
  ]
  def deleteRemediationConfiguration(
      request: zio.aws.config.model.DeleteRemediationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DeleteRemediationConfigurationResponse.ReadOnly
  ]
  def describeOrganizationConfigRules(
      request: zio.aws.config.model.DescribeOrganizationConfigRulesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.config.model.OrganizationConfigRule.ReadOnly
  ]
  def describeOrganizationConfigRulesPaginated(
      request: zio.aws.config.model.DescribeOrganizationConfigRulesRequest
  ): IO[
    AwsError,
    zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly
  ]
  def deleteConfigurationRecorder(
      request: zio.aws.config.model.DeleteConfigurationRecorderRequest
  ): IO[AwsError, Unit]
  def listResourceEvaluations(
      request: zio.aws.config.model.ListResourceEvaluationsRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.ResourceEvaluation.ReadOnly]
  def listResourceEvaluationsPaginated(
      request: zio.aws.config.model.ListResourceEvaluationsRequest
  ): IO[AwsError, zio.aws.config.model.ListResourceEvaluationsResponse.ReadOnly]
  def batchGetResourceConfig(
      request: zio.aws.config.model.BatchGetResourceConfigRequest
  ): IO[AwsError, zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly]
  def batchGetAggregateResourceConfig(
      request: zio.aws.config.model.BatchGetAggregateResourceConfigRequest
  ): IO[
    AwsError,
    zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly
  ]
  def listDiscoveredResources(
      request: zio.aws.config.model.ListDiscoveredResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.config.model.ResourceIdentifier.ReadOnly]
  def listDiscoveredResourcesPaginated(
      request: zio.aws.config.model.ListDiscoveredResourcesRequest
  ): IO[AwsError, zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly]
  def getDiscoveredResourceCounts(
      request: zio.aws.config.model.GetDiscoveredResourceCountsRequest
  ): IO[
    AwsError,
    zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly
  ]
  def deliverConfigSnapshot(
      request: zio.aws.config.model.DeliverConfigSnapshotRequest
  ): IO[AwsError, zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly]
  def putRetentionConfiguration(
      request: zio.aws.config.model.PutRetentionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly
  ]
}
object Config {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Config] = customized(
    identity
  )
  def customized(
      customization: ConfigAsyncClientBuilder => ConfigAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Config] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ConfigAsyncClientBuilder => ConfigAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Config] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ConfigAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[ConfigAsyncClient, ConfigAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[ConfigAsyncClient, ConfigAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new ConfigImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ConfigImpl[R](
      override val api: ConfigAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Config
      with AwsServiceBase[R] {
    override val serviceName: String = "Config"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ConfigImpl[R1] = new ConfigImpl(api, newAspect, r)
    def getResourceEvaluationSummary(
        request: zio.aws.config.model.GetResourceEvaluationSummaryRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetResourceEvaluationSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourceEvaluationSummaryRequest,
      GetResourceEvaluationSummaryResponse
    ]("getResourceEvaluationSummary", api.getResourceEvaluationSummary)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetResourceEvaluationSummaryResponse.wrap)
      .provideEnvironment(r)
    def deleteRemediationExceptions(
        request: zio.aws.config.model.DeleteRemediationExceptionsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRemediationExceptionsRequest,
      DeleteRemediationExceptionsResponse
    ]("deleteRemediationExceptions", api.deleteRemediationExceptions)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DeleteRemediationExceptionsResponse.wrap)
      .provideEnvironment(r)
    def describeComplianceByConfigRule(
        request: zio.aws.config.model.DescribeComplianceByConfigRuleRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceByConfigRule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeComplianceByConfigRuleRequest,
      DescribeComplianceByConfigRuleResponse,
      ComplianceByConfigRule
    ](
      "describeComplianceByConfigRule",
      api.describeComplianceByConfigRule,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.complianceByConfigRules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ComplianceByConfigRule.wrap(item))
      .provideEnvironment(r)
    def describeComplianceByConfigRulePaginated(
        request: zio.aws.config.model.DescribeComplianceByConfigRuleRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeComplianceByConfigRuleRequest,
      DescribeComplianceByConfigRuleResponse
    ]("describeComplianceByConfigRule", api.describeComplianceByConfigRule)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeComplianceByConfigRuleResponse.wrap)
      .provideEnvironment(r)
    def putConfigurationAggregator(
        request: zio.aws.config.model.PutConfigurationAggregatorRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationAggregatorRequest,
      PutConfigurationAggregatorResponse
    ]("putConfigurationAggregator", api.putConfigurationAggregator)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutConfigurationAggregatorResponse.wrap)
      .provideEnvironment(r)
    def getComplianceSummaryByConfigRule(): IO[
      AwsError,
      zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      GetComplianceSummaryByConfigRuleRequest,
      GetComplianceSummaryByConfigRuleResponse
    ]("getComplianceSummaryByConfigRule", api.getComplianceSummaryByConfigRule)(
      GetComplianceSummaryByConfigRuleRequest.builder().build()
    ).map(zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.wrap)
      .provideEnvironment(r)
    def getAggregateConfigRuleComplianceSummary(
        request: zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly,
      zio.aws.config.model.AggregateComplianceCount.ReadOnly
    ]] = asyncPaginatedRequest[
      GetAggregateConfigRuleComplianceSummaryRequest,
      GetAggregateConfigRuleComplianceSummaryResponse,
      AggregateComplianceCount
    ](
      "getAggregateConfigRuleComplianceSummary",
      api.getAggregateConfigRuleComplianceSummary,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.aggregateComplianceCounts().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.config.model.AggregateComplianceCount.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getAggregateConfigRuleComplianceSummaryPaginated(
        request: zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAggregateConfigRuleComplianceSummaryRequest,
      GetAggregateConfigRuleComplianceSummaryResponse
    ](
      "getAggregateConfigRuleComplianceSummary",
      api.getAggregateConfigRuleComplianceSummary
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.wrap
      )
      .provideEnvironment(r)
    def describeDeliveryChannelStatus(
        request: zio.aws.config.model.DescribeDeliveryChannelStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDeliveryChannelStatusRequest,
      DescribeDeliveryChannelStatusResponse
    ]("describeDeliveryChannelStatus", api.describeDeliveryChannelStatus)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeDeliveryChannelStatusResponse.wrap)
      .provideEnvironment(r)
    def describeAggregationAuthorizations(
        request: zio.aws.config.model.DescribeAggregationAuthorizationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.AggregationAuthorization.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAggregationAuthorizationsRequest,
      DescribeAggregationAuthorizationsResponse,
      AggregationAuthorization
    ](
      "describeAggregationAuthorizations",
      api.describeAggregationAuthorizations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.aggregationAuthorizations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.AggregationAuthorization.wrap(item))
      .provideEnvironment(r)
    def describeAggregationAuthorizationsPaginated(
        request: zio.aws.config.model.DescribeAggregationAuthorizationsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAggregationAuthorizationsRequest,
      DescribeAggregationAuthorizationsResponse
    ](
      "describeAggregationAuthorizations",
      api.describeAggregationAuthorizations
    )(request.buildAwsValue())
      .map(zio.aws.config.model.DescribeAggregationAuthorizationsResponse.wrap)
      .provideEnvironment(r)
    def getOrganizationConfigRuleDetailedStatus(
        request: zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.MemberAccountStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetOrganizationConfigRuleDetailedStatusRequest,
      GetOrganizationConfigRuleDetailedStatusResponse,
      MemberAccountStatus
    ](
      "getOrganizationConfigRuleDetailedStatus",
      api.getOrganizationConfigRuleDetailedStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.organizationConfigRuleDetailedStatus().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.MemberAccountStatus.wrap(item))
      .provideEnvironment(r)
    def getOrganizationConfigRuleDetailedStatusPaginated(
        request: zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetOrganizationConfigRuleDetailedStatusRequest,
      GetOrganizationConfigRuleDetailedStatusResponse
    ](
      "getOrganizationConfigRuleDetailedStatus",
      api.getOrganizationConfigRuleDetailedStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.wrap
      )
      .provideEnvironment(r)
    def startConfigRulesEvaluation(
        request: zio.aws.config.model.StartConfigRulesEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.config.model.StartConfigRulesEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartConfigRulesEvaluationRequest,
      StartConfigRulesEvaluationResponse
    ]("startConfigRulesEvaluation", api.startConfigRulesEvaluation)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.StartConfigRulesEvaluationResponse.wrap)
      .provideEnvironment(r)
    def describeOrganizationConfigRuleStatuses(
        request: zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeOrganizationConfigRuleStatusesRequest,
      DescribeOrganizationConfigRuleStatusesResponse,
      OrganizationConfigRuleStatus
    ](
      "describeOrganizationConfigRuleStatuses",
      api.describeOrganizationConfigRuleStatuses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.organizationConfigRuleStatuses().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.OrganizationConfigRuleStatus.wrap(item))
      .provideEnvironment(r)
    def describeOrganizationConfigRuleStatusesPaginated(
        request: zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationConfigRuleStatusesRequest,
      DescribeOrganizationConfigRuleStatusesResponse
    ](
      "describeOrganizationConfigRuleStatuses",
      api.describeOrganizationConfigRuleStatuses
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.wrap
      )
      .provideEnvironment(r)
    def stopConfigurationRecorder(
        request: zio.aws.config.model.StopConfigurationRecorderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StopConfigurationRecorderRequest,
      StopConfigurationRecorderResponse
    ]("stopConfigurationRecorder", api.stopConfigurationRecorder)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putConfigurationRecorder(
        request: zio.aws.config.model.PutConfigurationRecorderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutConfigurationRecorderRequest,
      PutConfigurationRecorderResponse
    ]("putConfigurationRecorder", api.putConfigurationRecorder)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteOrganizationConformancePack(
        request: zio.aws.config.model.DeleteOrganizationConformancePackRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteOrganizationConformancePackRequest,
      DeleteOrganizationConformancePackResponse
    ](
      "deleteOrganizationConformancePack",
      api.deleteOrganizationConformancePack
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeConfigRuleEvaluationStatus(
        request: zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeConfigRuleEvaluationStatusRequest,
      DescribeConfigRuleEvaluationStatusResponse,
      ConfigRuleEvaluationStatus
    ](
      "describeConfigRuleEvaluationStatus",
      api.describeConfigRuleEvaluationStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.configRulesEvaluationStatus().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ConfigRuleEvaluationStatus.wrap(item))
      .provideEnvironment(r)
    def describeConfigRuleEvaluationStatusPaginated(
        request: zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigRuleEvaluationStatusRequest,
      DescribeConfigRuleEvaluationStatusResponse
    ](
      "describeConfigRuleEvaluationStatus",
      api.describeConfigRuleEvaluationStatus
    )(request.buildAwsValue())
      .map(zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.wrap)
      .provideEnvironment(r)
    def describeOrganizationConformancePackStatuses(
        request: zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeOrganizationConformancePackStatusesRequest,
      DescribeOrganizationConformancePackStatusesResponse,
      OrganizationConformancePackStatus
    ](
      "describeOrganizationConformancePackStatuses",
      api.describeOrganizationConformancePackStatuses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.organizationConformancePackStatuses().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.config.model.OrganizationConformancePackStatus.wrap(item)
      )
      .provideEnvironment(r)
    def describeOrganizationConformancePackStatusesPaginated(
        request: zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationConformancePackStatusesRequest,
      DescribeOrganizationConformancePackStatusesResponse
    ](
      "describeOrganizationConformancePackStatuses",
      api.describeOrganizationConformancePackStatuses
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.wrap
      )
      .provideEnvironment(r)
    def describeConfigurationAggregators(
        request: zio.aws.config.model.DescribeConfigurationAggregatorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ConfigurationAggregator.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeConfigurationAggregatorsRequest,
      DescribeConfigurationAggregatorsResponse,
      ConfigurationAggregator
    ](
      "describeConfigurationAggregators",
      api.describeConfigurationAggregators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.configurationAggregators().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ConfigurationAggregator.wrap(item))
      .provideEnvironment(r)
    def describeConfigurationAggregatorsPaginated(
        request: zio.aws.config.model.DescribeConfigurationAggregatorsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationAggregatorsRequest,
      DescribeConfigurationAggregatorsResponse
    ]("describeConfigurationAggregators", api.describeConfigurationAggregators)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeConfigurationAggregatorsResponse.wrap)
      .provideEnvironment(r)
    def describeDeliveryChannels(
        request: zio.aws.config.model.DescribeDeliveryChannelsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeDeliveryChannelsRequest,
      DescribeDeliveryChannelsResponse
    ]("describeDeliveryChannels", api.describeDeliveryChannels)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeDeliveryChannelsResponse.wrap)
      .provideEnvironment(r)
    def deleteOrganizationConfigRule(
        request: zio.aws.config.model.DeleteOrganizationConfigRuleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteOrganizationConfigRuleRequest,
      DeleteOrganizationConfigRuleResponse
    ]("deleteOrganizationConfigRule", api.deleteOrganizationConfigRule)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putDeliveryChannel(
        request: zio.aws.config.model.PutDeliveryChannelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutDeliveryChannelRequest,
      PutDeliveryChannelResponse
    ]("putDeliveryChannel", api.putDeliveryChannel)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listAggregateDiscoveredResources(
        request: zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAggregateDiscoveredResourcesRequest,
      ListAggregateDiscoveredResourcesResponse,
      AggregateResourceIdentifier
    ](
      "listAggregateDiscoveredResources",
      api.listAggregateDiscoveredResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceIdentifiers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.AggregateResourceIdentifier.wrap(item))
      .provideEnvironment(r)
    def listAggregateDiscoveredResourcesPaginated(
        request: zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
    ): IO[
      AwsError,
      zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAggregateDiscoveredResourcesRequest,
      ListAggregateDiscoveredResourcesResponse
    ]("listAggregateDiscoveredResources", api.listAggregateDiscoveredResources)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.wrap)
      .provideEnvironment(r)
    def describePendingAggregationRequests(
        request: zio.aws.config.model.DescribePendingAggregationRequestsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.PendingAggregationRequest.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribePendingAggregationRequestsRequest,
      DescribePendingAggregationRequestsResponse,
      PendingAggregationRequest
    ](
      "describePendingAggregationRequests",
      api.describePendingAggregationRequests,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pendingAggregationRequests().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.PendingAggregationRequest.wrap(item))
      .provideEnvironment(r)
    def describePendingAggregationRequestsPaginated(
        request: zio.aws.config.model.DescribePendingAggregationRequestsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePendingAggregationRequestsRequest,
      DescribePendingAggregationRequestsResponse
    ](
      "describePendingAggregationRequests",
      api.describePendingAggregationRequests
    )(request.buildAwsValue())
      .map(zio.aws.config.model.DescribePendingAggregationRequestsResponse.wrap)
      .provideEnvironment(r)
    def describeAggregateComplianceByConfigRules(
        request: zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAggregateComplianceByConfigRulesRequest,
      DescribeAggregateComplianceByConfigRulesResponse,
      AggregateComplianceByConfigRule
    ](
      "describeAggregateComplianceByConfigRules",
      api.describeAggregateComplianceByConfigRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.aggregateComplianceByConfigRules().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.config.model.AggregateComplianceByConfigRule.wrap(item)
      )
      .provideEnvironment(r)
    def describeAggregateComplianceByConfigRulesPaginated(
        request: zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAggregateComplianceByConfigRulesRequest,
      DescribeAggregateComplianceByConfigRulesResponse
    ](
      "describeAggregateComplianceByConfigRules",
      api.describeAggregateComplianceByConfigRules
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteEvaluationResults(
        request: zio.aws.config.model.DeleteEvaluationResultsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DeleteEvaluationResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEvaluationResultsRequest,
      DeleteEvaluationResultsResponse
    ]("deleteEvaluationResults", api.deleteEvaluationResults)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DeleteEvaluationResultsResponse.wrap)
      .provideEnvironment(r)
    def describeRemediationConfigurations(
        request: zio.aws.config.model.DescribeRemediationConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRemediationConfigurationsRequest,
      DescribeRemediationConfigurationsResponse
    ](
      "describeRemediationConfigurations",
      api.describeRemediationConfigurations
    )(request.buildAwsValue())
      .map(zio.aws.config.model.DescribeRemediationConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def getComplianceDetailsByResource(
        request: zio.aws.config.model.GetComplianceDetailsByResourceRequest
    ): ZStream[Any, AwsError, zio.aws.config.model.EvaluationResult.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetComplianceDetailsByResourceRequest,
        GetComplianceDetailsByResourceResponse,
        EvaluationResult
      ](
        "getComplianceDetailsByResource",
        api.getComplianceDetailsByResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.evaluationResults().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.config.model.EvaluationResult.wrap(item))
        .provideEnvironment(r)
    def getComplianceDetailsByResourcePaginated(
        request: zio.aws.config.model.GetComplianceDetailsByResourceRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      GetComplianceDetailsByResourceRequest,
      GetComplianceDetailsByResourceResponse
    ]("getComplianceDetailsByResource", api.getComplianceDetailsByResource)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetComplianceDetailsByResourceResponse.wrap)
      .provideEnvironment(r)
    def describeRemediationExceptions(
        request: zio.aws.config.model.DescribeRemediationExceptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.RemediationException.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeRemediationExceptionsRequest,
      DescribeRemediationExceptionsResponse,
      RemediationException
    ](
      "describeRemediationExceptions",
      api.describeRemediationExceptions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.remediationExceptions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.RemediationException.wrap(item))
      .provideEnvironment(r)
    def describeRemediationExceptionsPaginated(
        request: zio.aws.config.model.DescribeRemediationExceptionsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRemediationExceptionsRequest,
      DescribeRemediationExceptionsResponse
    ]("describeRemediationExceptions", api.describeRemediationExceptions)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeRemediationExceptionsResponse.wrap)
      .provideEnvironment(r)
    def listStoredQueries(
        request: zio.aws.config.model.ListStoredQueriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.StoredQueryMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListStoredQueriesRequest,
      ListStoredQueriesResponse,
      StoredQueryMetadata
    ](
      "listStoredQueries",
      api.listStoredQueries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.storedQueryMetadata().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.StoredQueryMetadata.wrap(item))
      .provideEnvironment(r)
    def listStoredQueriesPaginated(
        request: zio.aws.config.model.ListStoredQueriesRequest
    ): IO[AwsError, zio.aws.config.model.ListStoredQueriesResponse.ReadOnly] =
      asyncRequestResponse[ListStoredQueriesRequest, ListStoredQueriesResponse](
        "listStoredQueries",
        api.listStoredQueries
      )(request.buildAwsValue())
        .map(zio.aws.config.model.ListStoredQueriesResponse.wrap)
        .provideEnvironment(r)
    def deleteResourceConfig(
        request: zio.aws.config.model.DeleteResourceConfigRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteResourceConfigRequest,
      DeleteResourceConfigResponse
    ]("deleteResourceConfig", api.deleteResourceConfig)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putRemediationExceptions(
        request: zio.aws.config.model.PutRemediationExceptionsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutRemediationExceptionsRequest,
      PutRemediationExceptionsResponse
    ]("putRemediationExceptions", api.putRemediationExceptions)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutRemediationExceptionsResponse.wrap)
      .provideEnvironment(r)
    def deleteConformancePack(
        request: zio.aws.config.model.DeleteConformancePackRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteConformancePackRequest,
      DeleteConformancePackResponse
    ]("deleteConformancePack", api.deleteConformancePack)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteRetentionConfiguration(
        request: zio.aws.config.model.DeleteRetentionConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRetentionConfigurationRequest,
      DeleteRetentionConfigurationResponse
    ]("deleteRetentionConfiguration", api.deleteRetentionConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putExternalEvaluation(
        request: zio.aws.config.model.PutExternalEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutExternalEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutExternalEvaluationRequest,
      PutExternalEvaluationResponse
    ]("putExternalEvaluation", api.putExternalEvaluation)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutExternalEvaluationResponse.wrap)
      .provideEnvironment(r)
    def getConformancePackComplianceSummary(
        request: zio.aws.config.model.GetConformancePackComplianceSummaryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetConformancePackComplianceSummaryRequest,
      GetConformancePackComplianceSummaryResponse,
      ConformancePackComplianceSummary
    ](
      "getConformancePackComplianceSummary",
      api.getConformancePackComplianceSummary,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.conformancePackComplianceSummaryList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.config.model.ConformancePackComplianceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def getConformancePackComplianceSummaryPaginated(
        request: zio.aws.config.model.GetConformancePackComplianceSummaryRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetConformancePackComplianceSummaryRequest,
      GetConformancePackComplianceSummaryResponse
    ](
      "getConformancePackComplianceSummary",
      api.getConformancePackComplianceSummary
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetConformancePackComplianceSummaryResponse.wrap
      )
      .provideEnvironment(r)
    def deleteConfigRule(
        request: zio.aws.config.model.DeleteConfigRuleRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteConfigRuleRequest, DeleteConfigRuleResponse](
        "deleteConfigRule",
        api.deleteConfigRule
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeConfigurationRecorders(
        request: zio.aws.config.model.DescribeConfigurationRecordersRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationRecordersRequest,
      DescribeConfigurationRecordersResponse
    ]("describeConfigurationRecorders", api.describeConfigurationRecorders)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeConfigurationRecordersResponse.wrap)
      .provideEnvironment(r)
    def selectAggregateResourceConfig(
        request: zio.aws.config.model.SelectAggregateResourceConfigRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly,
      String
    ]] = asyncPaginatedRequest[
      SelectAggregateResourceConfigRequest,
      SelectAggregateResourceConfigResponse,
      java.lang.String
    ](
      "selectAggregateResourceConfig",
      api.selectAggregateResourceConfig,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.results().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.config.model.SelectAggregateResourceConfigResponse.wrap
          )
          .mapOutput(_.map(item => item: String))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def selectAggregateResourceConfigPaginated(
        request: zio.aws.config.model.SelectAggregateResourceConfigRequest
    ): IO[
      AwsError,
      zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      SelectAggregateResourceConfigRequest,
      SelectAggregateResourceConfigResponse
    ]("selectAggregateResourceConfig", api.selectAggregateResourceConfig)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.SelectAggregateResourceConfigResponse.wrap)
      .provideEnvironment(r)
    def describeOrganizationConformancePacks(
        request: zio.aws.config.model.DescribeOrganizationConformancePacksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationConformancePack.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeOrganizationConformancePacksRequest,
      DescribeOrganizationConformancePacksResponse,
      OrganizationConformancePack
    ](
      "describeOrganizationConformancePacks",
      api.describeOrganizationConformancePacks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.organizationConformancePacks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.OrganizationConformancePack.wrap(item))
      .provideEnvironment(r)
    def describeOrganizationConformancePacksPaginated(
        request: zio.aws.config.model.DescribeOrganizationConformancePacksRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationConformancePacksRequest,
      DescribeOrganizationConformancePacksResponse
    ](
      "describeOrganizationConformancePacks",
      api.describeOrganizationConformancePacks
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeOrganizationConformancePacksResponse.wrap
      )
      .provideEnvironment(r)
    def getStoredQuery(
        request: zio.aws.config.model.GetStoredQueryRequest
    ): IO[AwsError, zio.aws.config.model.GetStoredQueryResponse.ReadOnly] =
      asyncRequestResponse[GetStoredQueryRequest, GetStoredQueryResponse](
        "getStoredQuery",
        api.getStoredQuery
      )(request.buildAwsValue())
        .map(zio.aws.config.model.GetStoredQueryResponse.wrap)
        .provideEnvironment(r)
    def deletePendingAggregationRequest(
        request: zio.aws.config.model.DeletePendingAggregationRequestRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeletePendingAggregationRequestRequest,
      DeletePendingAggregationRequestResponse
    ]("deletePendingAggregationRequest", api.deletePendingAggregationRequest)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getCustomRulePolicy(
        request: zio.aws.config.model.GetCustomRulePolicyRequest
    ): IO[AwsError, zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        GetCustomRulePolicyRequest,
        GetCustomRulePolicyResponse
      ]("getCustomRulePolicy", api.getCustomRulePolicy)(request.buildAwsValue())
        .map(zio.aws.config.model.GetCustomRulePolicyResponse.wrap)
        .provideEnvironment(r)
    def startConfigurationRecorder(
        request: zio.aws.config.model.StartConfigurationRecorderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StartConfigurationRecorderRequest,
      StartConfigurationRecorderResponse
    ]("startConfigurationRecorder", api.startConfigurationRecorder)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putStoredQuery(
        request: zio.aws.config.model.PutStoredQueryRequest
    ): IO[AwsError, zio.aws.config.model.PutStoredQueryResponse.ReadOnly] =
      asyncRequestResponse[PutStoredQueryRequest, PutStoredQueryResponse](
        "putStoredQuery",
        api.putStoredQuery
      )(request.buildAwsValue())
        .map(zio.aws.config.model.PutStoredQueryResponse.wrap)
        .provideEnvironment(r)
    def getComplianceSummaryByResourceType(
        request: zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      GetComplianceSummaryByResourceTypeRequest,
      GetComplianceSummaryByResourceTypeResponse
    ](
      "getComplianceSummaryByResourceType",
      api.getComplianceSummaryByResourceType
    )(request.buildAwsValue())
      .map(zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.wrap)
      .provideEnvironment(r)
    def describeConfigRules(
        request: zio.aws.config.model.DescribeConfigRulesRequest
    ): ZStream[Any, AwsError, zio.aws.config.model.ConfigRule.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeConfigRulesRequest,
        DescribeConfigRulesResponse,
        ConfigRule
      ](
        "describeConfigRules",
        api.describeConfigRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.configRules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.config.model.ConfigRule.wrap(item))
        .provideEnvironment(r)
    def describeConfigRulesPaginated(
        request: zio.aws.config.model.DescribeConfigRulesRequest
    ): IO[AwsError, zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeConfigRulesRequest,
        DescribeConfigRulesResponse
      ]("describeConfigRules", api.describeConfigRules)(request.buildAwsValue())
        .map(zio.aws.config.model.DescribeConfigRulesResponse.wrap)
        .provideEnvironment(r)
    def describeConformancePacks(
        request: zio.aws.config.model.DescribeConformancePacksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackDetail.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeConformancePacksRequest,
      DescribeConformancePacksResponse,
      ConformancePackDetail
    ](
      "describeConformancePacks",
      api.describeConformancePacks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.conformancePackDetails().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ConformancePackDetail.wrap(item))
      .provideEnvironment(r)
    def describeConformancePacksPaginated(
        request: zio.aws.config.model.DescribeConformancePacksRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConformancePacksRequest,
      DescribeConformancePacksResponse
    ]("describeConformancePacks", api.describeConformancePacks)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeConformancePacksResponse.wrap)
      .provideEnvironment(r)
    def getAggregateResourceConfig(
        request: zio.aws.config.model.GetAggregateResourceConfigRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAggregateResourceConfigRequest,
      GetAggregateResourceConfigResponse
    ]("getAggregateResourceConfig", api.getAggregateResourceConfig)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetAggregateResourceConfigResponse.wrap)
      .provideEnvironment(r)
    def getAggregateDiscoveredResourceCounts(
        request: zio.aws.config.model.GetAggregateDiscoveredResourceCountsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly,
      zio.aws.config.model.GroupedResourceCount.ReadOnly
    ]] = asyncPaginatedRequest[
      GetAggregateDiscoveredResourceCountsRequest,
      GetAggregateDiscoveredResourceCountsResponse,
      GroupedResourceCount
    ](
      "getAggregateDiscoveredResourceCounts",
      api.getAggregateDiscoveredResourceCounts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.groupedResourceCounts().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.config.model.GroupedResourceCount.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getAggregateDiscoveredResourceCountsPaginated(
        request: zio.aws.config.model.GetAggregateDiscoveredResourceCountsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAggregateDiscoveredResourceCountsRequest,
      GetAggregateDiscoveredResourceCountsResponse
    ](
      "getAggregateDiscoveredResourceCounts",
      api.getAggregateDiscoveredResourceCounts
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.wrap
      )
      .provideEnvironment(r)
    def describeConformancePackCompliance(
        request: zio.aws.config.model.DescribeConformancePackComplianceRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly,
      zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeConformancePackComplianceRequest,
      DescribeConformancePackComplianceResponse,
      ConformancePackRuleCompliance
    ](
      "describeConformancePackCompliance",
      api.describeConformancePackCompliance,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.conformancePackRuleComplianceList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.config.model.DescribeConformancePackComplianceResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.config.model.ConformancePackRuleCompliance.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeConformancePackCompliancePaginated(
        request: zio.aws.config.model.DescribeConformancePackComplianceRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConformancePackComplianceRequest,
      DescribeConformancePackComplianceResponse
    ](
      "describeConformancePackCompliance",
      api.describeConformancePackCompliance
    )(request.buildAwsValue())
      .map(zio.aws.config.model.DescribeConformancePackComplianceResponse.wrap)
      .provideEnvironment(r)
    def describeComplianceByResource(
        request: zio.aws.config.model.DescribeComplianceByResourceRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceByResource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeComplianceByResourceRequest,
      DescribeComplianceByResourceResponse,
      ComplianceByResource
    ](
      "describeComplianceByResource",
      api.describeComplianceByResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.complianceByResources().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ComplianceByResource.wrap(item))
      .provideEnvironment(r)
    def describeComplianceByResourcePaginated(
        request: zio.aws.config.model.DescribeComplianceByResourceRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeComplianceByResourceRequest,
      DescribeComplianceByResourceResponse
    ]("describeComplianceByResource", api.describeComplianceByResource)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeComplianceByResourceResponse.wrap)
      .provideEnvironment(r)
    def putRemediationConfigurations(
        request: zio.aws.config.model.PutRemediationConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutRemediationConfigurationsRequest,
      PutRemediationConfigurationsResponse
    ]("putRemediationConfigurations", api.putRemediationConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutRemediationConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.config.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeAggregateComplianceByConformancePacks(
        request: zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAggregateComplianceByConformancePacksRequest,
      DescribeAggregateComplianceByConformancePacksResponse,
      AggregateComplianceByConformancePack
    ](
      "describeAggregateComplianceByConformancePacks",
      api.describeAggregateComplianceByConformancePacks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.aggregateComplianceByConformancePacks().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.config.model.AggregateComplianceByConformancePack.wrap(item)
      )
      .provideEnvironment(r)
    def describeAggregateComplianceByConformancePacksPaginated(
        request: zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAggregateComplianceByConformancePacksRequest,
      DescribeAggregateComplianceByConformancePacksResponse
    ](
      "describeAggregateComplianceByConformancePacks",
      api.describeAggregateComplianceByConformancePacks
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.wrap
      )
      .provideEnvironment(r)
    def getResourceConfigHistory(
        request: zio.aws.config.model.GetResourceConfigHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.config.model.ConfigurationItem.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetResourceConfigHistoryRequest,
        ConfigurationItem,
        GetResourceConfigHistoryPublisher
      ](
        "getResourceConfigHistory",
        api.getResourceConfigHistoryPaginator,
        _.configurationItems()
      )(request.buildAwsValue())
        .map(item => zio.aws.config.model.ConfigurationItem.wrap(item))
        .provideEnvironment(r)
    def getResourceConfigHistoryPaginated(
        request: zio.aws.config.model.GetResourceConfigHistoryRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourceConfigHistoryRequest,
      GetResourceConfigHistoryResponse
    ]("getResourceConfigHistory", api.getResourceConfigHistory)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetResourceConfigHistoryResponse.wrap)
      .provideEnvironment(r)
    def describeRetentionConfigurations(
        request: zio.aws.config.model.DescribeRetentionConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.RetentionConfiguration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeRetentionConfigurationsRequest,
      DescribeRetentionConfigurationsResponse,
      RetentionConfiguration
    ](
      "describeRetentionConfigurations",
      api.describeRetentionConfigurations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.retentionConfigurations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.RetentionConfiguration.wrap(item))
      .provideEnvironment(r)
    def describeRetentionConfigurationsPaginated(
        request: zio.aws.config.model.DescribeRetentionConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRetentionConfigurationsRequest,
      DescribeRetentionConfigurationsResponse
    ]("describeRetentionConfigurations", api.describeRetentionConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeRetentionConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def putOrganizationConformancePack(
        request: zio.aws.config.model.PutOrganizationConformancePackRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly
    ] = asyncRequestResponse[
      PutOrganizationConformancePackRequest,
      PutOrganizationConformancePackResponse
    ]("putOrganizationConformancePack", api.putOrganizationConformancePack)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutOrganizationConformancePackResponse.wrap)
      .provideEnvironment(r)
    def listConformancePackComplianceScores(
        request: zio.aws.config.model.ListConformancePackComplianceScoresRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceScore.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListConformancePackComplianceScoresRequest,
      ListConformancePackComplianceScoresResponse,
      ConformancePackComplianceScore
    ](
      "listConformancePackComplianceScores",
      api.listConformancePackComplianceScores,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.conformancePackComplianceScores().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.config.model.ConformancePackComplianceScore.wrap(item)
      )
      .provideEnvironment(r)
    def listConformancePackComplianceScoresPaginated(
        request: zio.aws.config.model.ListConformancePackComplianceScoresRequest
    ): IO[
      AwsError,
      zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly
    ] = asyncRequestResponse[
      ListConformancePackComplianceScoresRequest,
      ListConformancePackComplianceScoresResponse
    ](
      "listConformancePackComplianceScores",
      api.listConformancePackComplianceScores
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.ListConformancePackComplianceScoresResponse.wrap
      )
      .provideEnvironment(r)
    def putOrganizationConfigRule(
        request: zio.aws.config.model.PutOrganizationConfigRuleRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      PutOrganizationConfigRuleRequest,
      PutOrganizationConfigRuleResponse
    ]("putOrganizationConfigRule", api.putOrganizationConfigRule)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutOrganizationConfigRuleResponse.wrap)
      .provideEnvironment(r)
    def putResourceConfig(
        request: zio.aws.config.model.PutResourceConfigRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutResourceConfigRequest, PutResourceConfigResponse](
        "putResourceConfig",
        api.putResourceConfig
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeConfigurationAggregatorSourcesStatus(
        request: zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.AggregatedSourceStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeConfigurationAggregatorSourcesStatusRequest,
      DescribeConfigurationAggregatorSourcesStatusResponse,
      AggregatedSourceStatus
    ](
      "describeConfigurationAggregatorSourcesStatus",
      api.describeConfigurationAggregatorSourcesStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.aggregatedSourceStatusList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.AggregatedSourceStatus.wrap(item))
      .provideEnvironment(r)
    def describeConfigurationAggregatorSourcesStatusPaginated(
        request: zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationAggregatorSourcesStatusRequest,
      DescribeConfigurationAggregatorSourcesStatusResponse
    ](
      "describeConfigurationAggregatorSourcesStatus",
      api.describeConfigurationAggregatorSourcesStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.wrap
      )
      .provideEnvironment(r)
    def deleteConfigurationAggregator(
        request: zio.aws.config.model.DeleteConfigurationAggregatorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteConfigurationAggregatorRequest,
      DeleteConfigurationAggregatorResponse
    ]("deleteConfigurationAggregator", api.deleteConfigurationAggregator)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeConformancePackStatus(
        request: zio.aws.config.model.DescribeConformancePackStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackStatusDetail.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeConformancePackStatusRequest,
      DescribeConformancePackStatusResponse,
      ConformancePackStatusDetail
    ](
      "describeConformancePackStatus",
      api.describeConformancePackStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.conformancePackStatusDetails().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ConformancePackStatusDetail.wrap(item))
      .provideEnvironment(r)
    def describeConformancePackStatusPaginated(
        request: zio.aws.config.model.DescribeConformancePackStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConformancePackStatusRequest,
      DescribeConformancePackStatusResponse
    ]("describeConformancePackStatus", api.describeConformancePackStatus)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeConformancePackStatusResponse.wrap)
      .provideEnvironment(r)
    def putConformancePack(
        request: zio.aws.config.model.PutConformancePackRequest
    ): IO[AwsError, zio.aws.config.model.PutConformancePackResponse.ReadOnly] =
      asyncRequestResponse[
        PutConformancePackRequest,
        PutConformancePackResponse
      ]("putConformancePack", api.putConformancePack)(request.buildAwsValue())
        .map(zio.aws.config.model.PutConformancePackResponse.wrap)
        .provideEnvironment(r)
    def deleteAggregationAuthorization(
        request: zio.aws.config.model.DeleteAggregationAuthorizationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAggregationAuthorizationRequest,
      DeleteAggregationAuthorizationResponse
    ]("deleteAggregationAuthorization", api.deleteAggregationAuthorization)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def startResourceEvaluation(
        request: zio.aws.config.model.StartResourceEvaluationRequest
    ): IO[
      AwsError,
      zio.aws.config.model.StartResourceEvaluationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartResourceEvaluationRequest,
      StartResourceEvaluationResponse
    ]("startResourceEvaluation", api.startResourceEvaluation)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.StartResourceEvaluationResponse.wrap)
      .provideEnvironment(r)
    def putEvaluations(
        request: zio.aws.config.model.PutEvaluationsRequest
    ): IO[AwsError, zio.aws.config.model.PutEvaluationsResponse.ReadOnly] =
      asyncRequestResponse[PutEvaluationsRequest, PutEvaluationsResponse](
        "putEvaluations",
        api.putEvaluations
      )(request.buildAwsValue())
        .map(zio.aws.config.model.PutEvaluationsResponse.wrap)
        .provideEnvironment(r)
    def deleteDeliveryChannel(
        request: zio.aws.config.model.DeleteDeliveryChannelRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteDeliveryChannelRequest,
      DeleteDeliveryChannelResponse
    ]("deleteDeliveryChannel", api.deleteDeliveryChannel)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putConfigRule(
        request: zio.aws.config.model.PutConfigRuleRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutConfigRuleRequest, PutConfigRuleResponse](
        "putConfigRule",
        api.putConfigRule
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.config.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.config.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.config.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.config.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.config.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.config.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getOrganizationConformancePackDetailedStatus(
        request: zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetOrganizationConformancePackDetailedStatusRequest,
      GetOrganizationConformancePackDetailedStatusResponse,
      OrganizationConformancePackDetailedStatus
    ](
      "getOrganizationConformancePackDetailedStatus",
      api.getOrganizationConformancePackDetailedStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.organizationConformancePackDetailedStatuses().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.config.model.OrganizationConformancePackDetailedStatus
          .wrap(item)
      )
      .provideEnvironment(r)
    def getOrganizationConformancePackDetailedStatusPaginated(
        request: zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetOrganizationConformancePackDetailedStatusRequest,
      GetOrganizationConformancePackDetailedStatusResponse
    ](
      "getOrganizationConformancePackDetailedStatus",
      api.getOrganizationConformancePackDetailedStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.config.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteStoredQuery(
        request: zio.aws.config.model.DeleteStoredQueryRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DeleteStoredQueryRequest, DeleteStoredQueryResponse](
        "deleteStoredQuery",
        api.deleteStoredQuery
      )(request.buildAwsValue())
        .map(zio.aws.config.model.DeleteStoredQueryResponse.wrap)
        .provideEnvironment(r)
    def getComplianceDetailsByConfigRule(
        request: zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
    ): ZStream[Any, AwsError, zio.aws.config.model.EvaluationResult.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetComplianceDetailsByConfigRuleRequest,
        GetComplianceDetailsByConfigRuleResponse,
        EvaluationResult
      ](
        "getComplianceDetailsByConfigRule",
        api.getComplianceDetailsByConfigRule,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.evaluationResults().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.config.model.EvaluationResult.wrap(item))
        .provideEnvironment(r)
    def getComplianceDetailsByConfigRulePaginated(
        request: zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      GetComplianceDetailsByConfigRuleRequest,
      GetComplianceDetailsByConfigRuleResponse
    ]("getComplianceDetailsByConfigRule", api.getComplianceDetailsByConfigRule)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.wrap)
      .provideEnvironment(r)
    def startRemediationExecution(
        request: zio.aws.config.model.StartRemediationExecutionRequest
    ): IO[
      AwsError,
      zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartRemediationExecutionRequest,
      StartRemediationExecutionResponse
    ]("startRemediationExecution", api.startRemediationExecution)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.StartRemediationExecutionResponse.wrap)
      .provideEnvironment(r)
    def getConformancePackComplianceDetails(
        request: zio.aws.config.model.GetConformancePackComplianceDetailsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly,
      zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly
    ]] = asyncPaginatedRequest[
      GetConformancePackComplianceDetailsRequest,
      GetConformancePackComplianceDetailsResponse,
      ConformancePackEvaluationResult
    ](
      "getConformancePackComplianceDetails",
      api.getConformancePackComplianceDetails,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.conformancePackRuleEvaluationResults().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.config.model.GetConformancePackComplianceDetailsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.config.model.ConformancePackEvaluationResult.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getConformancePackComplianceDetailsPaginated(
        request: zio.aws.config.model.GetConformancePackComplianceDetailsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetConformancePackComplianceDetailsRequest,
      GetConformancePackComplianceDetailsResponse
    ](
      "getConformancePackComplianceDetails",
      api.getConformancePackComplianceDetails
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetConformancePackComplianceDetailsResponse.wrap
      )
      .provideEnvironment(r)
    def selectResourceConfig(
        request: zio.aws.config.model.SelectResourceConfigRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.SelectResourceConfigResponse.ReadOnly,
      String
    ]] = asyncPaginatedRequest[
      SelectResourceConfigRequest,
      SelectResourceConfigResponse,
      java.lang.String
    ](
      "selectResourceConfig",
      api.selectResourceConfig,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.results().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.config.model.SelectResourceConfigResponse.wrap)
          .mapOutput(_.map(item => item: String))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def selectResourceConfigPaginated(
        request: zio.aws.config.model.SelectResourceConfigRequest
    ): IO[
      AwsError,
      zio.aws.config.model.SelectResourceConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      SelectResourceConfigRequest,
      SelectResourceConfigResponse
    ]("selectResourceConfig", api.selectResourceConfig)(request.buildAwsValue())
      .map(zio.aws.config.model.SelectResourceConfigResponse.wrap)
      .provideEnvironment(r)
    def describeRemediationExecutionStatus(
        request: zio.aws.config.model.DescribeRemediationExecutionStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.RemediationExecutionStatus.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeRemediationExecutionStatusRequest,
      DescribeRemediationExecutionStatusResponse,
      RemediationExecutionStatus
    ](
      "describeRemediationExecutionStatus",
      api.describeRemediationExecutionStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.remediationExecutionStatuses().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.RemediationExecutionStatus.wrap(item))
      .provideEnvironment(r)
    def describeRemediationExecutionStatusPaginated(
        request: zio.aws.config.model.DescribeRemediationExecutionStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRemediationExecutionStatusRequest,
      DescribeRemediationExecutionStatusResponse
    ](
      "describeRemediationExecutionStatus",
      api.describeRemediationExecutionStatus
    )(request.buildAwsValue())
      .map(zio.aws.config.model.DescribeRemediationExecutionStatusResponse.wrap)
      .provideEnvironment(r)
    def describeConfigurationRecorderStatus(
        request: zio.aws.config.model.DescribeConfigurationRecorderStatusRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationRecorderStatusRequest,
      DescribeConfigurationRecorderStatusResponse
    ](
      "describeConfigurationRecorderStatus",
      api.describeConfigurationRecorderStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.wrap
      )
      .provideEnvironment(r)
    def getOrganizationCustomRulePolicy(
        request: zio.aws.config.model.GetOrganizationCustomRulePolicyRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      GetOrganizationCustomRulePolicyRequest,
      GetOrganizationCustomRulePolicyResponse
    ]("getOrganizationCustomRulePolicy", api.getOrganizationCustomRulePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.wrap)
      .provideEnvironment(r)
    def getAggregateComplianceDetailsByConfigRule(
        request: zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.AggregateEvaluationResult.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetAggregateComplianceDetailsByConfigRuleRequest,
      GetAggregateComplianceDetailsByConfigRuleResponse,
      AggregateEvaluationResult
    ](
      "getAggregateComplianceDetailsByConfigRule",
      api.getAggregateComplianceDetailsByConfigRule,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.aggregateEvaluationResults().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.AggregateEvaluationResult.wrap(item))
      .provideEnvironment(r)
    def getAggregateComplianceDetailsByConfigRulePaginated(
        request: zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAggregateComplianceDetailsByConfigRuleRequest,
      GetAggregateComplianceDetailsByConfigRuleResponse
    ](
      "getAggregateComplianceDetailsByConfigRule",
      api.getAggregateComplianceDetailsByConfigRule
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.wrap
      )
      .provideEnvironment(r)
    def putAggregationAuthorization(
        request: zio.aws.config.model.PutAggregationAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAggregationAuthorizationRequest,
      PutAggregationAuthorizationResponse
    ]("putAggregationAuthorization", api.putAggregationAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutAggregationAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def getAggregateConformancePackComplianceSummary(
        request: zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly,
      zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      GetAggregateConformancePackComplianceSummaryRequest,
      GetAggregateConformancePackComplianceSummaryResponse,
      AggregateConformancePackComplianceSummary
    ](
      "getAggregateConformancePackComplianceSummary",
      api.getAggregateConformancePackComplianceSummary,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.aggregateConformancePackComplianceSummaries().asScala
        )
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.config.model.AggregateConformancePackComplianceSummary
                .wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getAggregateConformancePackComplianceSummaryPaginated(
        request: zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAggregateConformancePackComplianceSummaryRequest,
      GetAggregateConformancePackComplianceSummaryResponse
    ](
      "getAggregateConformancePackComplianceSummary",
      api.getAggregateConformancePackComplianceSummary
    )(request.buildAwsValue())
      .map(
        zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.wrap
      )
      .provideEnvironment(r)
    def deleteRemediationConfiguration(
        request: zio.aws.config.model.DeleteRemediationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DeleteRemediationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRemediationConfigurationRequest,
      DeleteRemediationConfigurationResponse
    ]("deleteRemediationConfiguration", api.deleteRemediationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DeleteRemediationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeOrganizationConfigRules(
        request: zio.aws.config.model.DescribeOrganizationConfigRulesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationConfigRule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeOrganizationConfigRulesRequest,
      DescribeOrganizationConfigRulesResponse,
      OrganizationConfigRule
    ](
      "describeOrganizationConfigRules",
      api.describeOrganizationConfigRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.organizationConfigRules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.OrganizationConfigRule.wrap(item))
      .provideEnvironment(r)
    def describeOrganizationConfigRulesPaginated(
        request: zio.aws.config.model.DescribeOrganizationConfigRulesRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationConfigRulesRequest,
      DescribeOrganizationConfigRulesResponse
    ]("describeOrganizationConfigRules", api.describeOrganizationConfigRules)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DescribeOrganizationConfigRulesResponse.wrap)
      .provideEnvironment(r)
    def deleteConfigurationRecorder(
        request: zio.aws.config.model.DeleteConfigurationRecorderRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteConfigurationRecorderRequest,
      DeleteConfigurationRecorderResponse
    ]("deleteConfigurationRecorder", api.deleteConfigurationRecorder)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listResourceEvaluations(
        request: zio.aws.config.model.ListResourceEvaluationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ResourceEvaluation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListResourceEvaluationsRequest,
      ListResourceEvaluationsResponse,
      ResourceEvaluation
    ](
      "listResourceEvaluations",
      api.listResourceEvaluations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceEvaluations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ResourceEvaluation.wrap(item))
      .provideEnvironment(r)
    def listResourceEvaluationsPaginated(
        request: zio.aws.config.model.ListResourceEvaluationsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.ListResourceEvaluationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListResourceEvaluationsRequest,
      ListResourceEvaluationsResponse
    ]("listResourceEvaluations", api.listResourceEvaluations)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.ListResourceEvaluationsResponse.wrap)
      .provideEnvironment(r)
    def batchGetResourceConfig(
        request: zio.aws.config.model.BatchGetResourceConfigRequest
    ): IO[
      AwsError,
      zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetResourceConfigRequest,
      BatchGetResourceConfigResponse
    ]("batchGetResourceConfig", api.batchGetResourceConfig)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.BatchGetResourceConfigResponse.wrap)
      .provideEnvironment(r)
    def batchGetAggregateResourceConfig(
        request: zio.aws.config.model.BatchGetAggregateResourceConfigRequest
    ): IO[
      AwsError,
      zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetAggregateResourceConfigRequest,
      BatchGetAggregateResourceConfigResponse
    ]("batchGetAggregateResourceConfig", api.batchGetAggregateResourceConfig)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.BatchGetAggregateResourceConfigResponse.wrap)
      .provideEnvironment(r)
    def listDiscoveredResources(
        request: zio.aws.config.model.ListDiscoveredResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.config.model.ResourceIdentifier.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDiscoveredResourcesRequest,
      ResourceIdentifier,
      ListDiscoveredResourcesPublisher
    ](
      "listDiscoveredResources",
      api.listDiscoveredResourcesPaginator,
      _.resourceIdentifiers()
    )(request.buildAwsValue())
      .map(item => zio.aws.config.model.ResourceIdentifier.wrap(item))
      .provideEnvironment(r)
    def listDiscoveredResourcesPaginated(
        request: zio.aws.config.model.ListDiscoveredResourcesRequest
    ): IO[
      AwsError,
      zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDiscoveredResourcesRequest,
      ListDiscoveredResourcesResponse
    ]("listDiscoveredResources", api.listDiscoveredResources)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.ListDiscoveredResourcesResponse.wrap)
      .provideEnvironment(r)
    def getDiscoveredResourceCounts(
        request: zio.aws.config.model.GetDiscoveredResourceCountsRequest
    ): IO[
      AwsError,
      zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDiscoveredResourceCountsRequest,
      GetDiscoveredResourceCountsResponse
    ]("getDiscoveredResourceCounts", api.getDiscoveredResourceCounts)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.GetDiscoveredResourceCountsResponse.wrap)
      .provideEnvironment(r)
    def deliverConfigSnapshot(
        request: zio.aws.config.model.DeliverConfigSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      DeliverConfigSnapshotRequest,
      DeliverConfigSnapshotResponse
    ]("deliverConfigSnapshot", api.deliverConfigSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.DeliverConfigSnapshotResponse.wrap)
      .provideEnvironment(r)
    def putRetentionConfiguration(
        request: zio.aws.config.model.PutRetentionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutRetentionConfigurationRequest,
      PutRetentionConfigurationResponse
    ]("putRetentionConfiguration", api.putRetentionConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.config.model.PutRetentionConfigurationResponse.wrap)
      .provideEnvironment(r)
  }
  def getResourceEvaluationSummary(
      request: zio.aws.config.model.GetResourceEvaluationSummaryRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetResourceEvaluationSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceEvaluationSummary(request))
  def deleteRemediationExceptions(
      request: zio.aws.config.model.DeleteRemediationExceptionsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRemediationExceptions(request))
  def describeComplianceByConfigRule(
      request: zio.aws.config.model.DescribeComplianceByConfigRuleRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ComplianceByConfigRule.ReadOnly
  ] = ZStream.serviceWithStream(_.describeComplianceByConfigRule(request))
  def describeComplianceByConfigRulePaginated(
      request: zio.aws.config.model.DescribeComplianceByConfigRuleRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeComplianceByConfigRulePaginated(request))
  def putConfigurationAggregator(
      request: zio.aws.config.model.PutConfigurationAggregatorRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationAggregator(request))
  def getComplianceSummaryByConfigRule(): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComplianceSummaryByConfigRule())
  def getAggregateConfigRuleComplianceSummary(
      request: zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly,
    zio.aws.config.model.AggregateComplianceCount.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getAggregateConfigRuleComplianceSummary(request))
  def getAggregateConfigRuleComplianceSummaryPaginated(
      request: zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getAggregateConfigRuleComplianceSummaryPaginated(request)
  )
  def describeDeliveryChannelStatus(
      request: zio.aws.config.model.DescribeDeliveryChannelStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDeliveryChannelStatus(request))
  def describeAggregationAuthorizations(
      request: zio.aws.config.model.DescribeAggregationAuthorizationsRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.AggregationAuthorization.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAggregationAuthorizations(request))
  def describeAggregationAuthorizationsPaginated(
      request: zio.aws.config.model.DescribeAggregationAuthorizationsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAggregationAuthorizationsPaginated(request))
  def getOrganizationConfigRuleDetailedStatus(
      request: zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.MemberAccountStatus.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getOrganizationConfigRuleDetailedStatus(request)
  )
  def getOrganizationConfigRuleDetailedStatusPaginated(
      request: zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getOrganizationConfigRuleDetailedStatusPaginated(request)
  )
  def startConfigRulesEvaluation(
      request: zio.aws.config.model.StartConfigRulesEvaluationRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.StartConfigRulesEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startConfigRulesEvaluation(request))
  def describeOrganizationConfigRuleStatuses(
      request: zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeOrganizationConfigRuleStatuses(request))
  def describeOrganizationConfigRuleStatusesPaginated(
      request: zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeOrganizationConfigRuleStatusesPaginated(request)
  )
  def stopConfigurationRecorder(
      request: zio.aws.config.model.StopConfigurationRecorderRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopConfigurationRecorder(request))
  def putConfigurationRecorder(
      request: zio.aws.config.model.PutConfigurationRecorderRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putConfigurationRecorder(request))
  def deleteOrganizationConformancePack(
      request: zio.aws.config.model.DeleteOrganizationConformancePackRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteOrganizationConformancePack(request))
  def describeConfigRuleEvaluationStatus(
      request: zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConfigRuleEvaluationStatus(request))
  def describeConfigRuleEvaluationStatusPaginated(
      request: zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigRuleEvaluationStatusPaginated(request))
  def describeOrganizationConformancePackStatuses(
      request: zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeOrganizationConformancePackStatuses(request)
  )
  def describeOrganizationConformancePackStatusesPaginated(
      request: zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeOrganizationConformancePackStatusesPaginated(request)
  )
  def describeConfigurationAggregators(
      request: zio.aws.config.model.DescribeConfigurationAggregatorsRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConfigurationAggregator.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConfigurationAggregators(request))
  def describeConfigurationAggregatorsPaginated(
      request: zio.aws.config.model.DescribeConfigurationAggregatorsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationAggregatorsPaginated(request))
  def describeDeliveryChannels(
      request: zio.aws.config.model.DescribeDeliveryChannelsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDeliveryChannels(request))
  def deleteOrganizationConfigRule(
      request: zio.aws.config.model.DeleteOrganizationConfigRuleRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteOrganizationConfigRule(request))
  def putDeliveryChannel(
      request: zio.aws.config.model.PutDeliveryChannelRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putDeliveryChannel(request))
  def listAggregateDiscoveredResources(
      request: zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listAggregateDiscoveredResources(request))
  def listAggregateDiscoveredResourcesPaginated(
      request: zio.aws.config.model.ListAggregateDiscoveredResourcesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAggregateDiscoveredResourcesPaginated(request))
  def describePendingAggregationRequests(
      request: zio.aws.config.model.DescribePendingAggregationRequestsRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PendingAggregationRequest.ReadOnly
  ] = ZStream.serviceWithStream(_.describePendingAggregationRequests(request))
  def describePendingAggregationRequestsPaginated(
      request: zio.aws.config.model.DescribePendingAggregationRequestsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePendingAggregationRequestsPaginated(request))
  def describeAggregateComplianceByConfigRules(
      request: zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeAggregateComplianceByConfigRules(request)
  )
  def describeAggregateComplianceByConfigRulesPaginated(
      request: zio.aws.config.model.DescribeAggregateComplianceByConfigRulesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeAggregateComplianceByConfigRulesPaginated(request)
  )
  def deleteEvaluationResults(
      request: zio.aws.config.model.DeleteEvaluationResultsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DeleteEvaluationResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEvaluationResults(request))
  def describeRemediationConfigurations(
      request: zio.aws.config.model.DescribeRemediationConfigurationsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRemediationConfigurations(request))
  def getComplianceDetailsByResource(
      request: zio.aws.config.model.GetComplianceDetailsByResourceRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.EvaluationResult.ReadOnly
  ] = ZStream.serviceWithStream(_.getComplianceDetailsByResource(request))
  def getComplianceDetailsByResourcePaginated(
      request: zio.aws.config.model.GetComplianceDetailsByResourceRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComplianceDetailsByResourcePaginated(request))
  def describeRemediationExceptions(
      request: zio.aws.config.model.DescribeRemediationExceptionsRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.RemediationException.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRemediationExceptions(request))
  def describeRemediationExceptionsPaginated(
      request: zio.aws.config.model.DescribeRemediationExceptionsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRemediationExceptionsPaginated(request))
  def listStoredQueries(
      request: zio.aws.config.model.ListStoredQueriesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.StoredQueryMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listStoredQueries(request))
  def listStoredQueriesPaginated(
      request: zio.aws.config.model.ListStoredQueriesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ListStoredQueriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStoredQueriesPaginated(request))
  def deleteResourceConfig(
      request: zio.aws.config.model.DeleteResourceConfigRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteResourceConfig(request))
  def putRemediationExceptions(
      request: zio.aws.config.model.PutRemediationExceptionsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRemediationExceptions(request))
  def deleteConformancePack(
      request: zio.aws.config.model.DeleteConformancePackRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConformancePack(request))
  def deleteRetentionConfiguration(
      request: zio.aws.config.model.DeleteRetentionConfigurationRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRetentionConfiguration(request))
  def putExternalEvaluation(
      request: zio.aws.config.model.PutExternalEvaluationRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutExternalEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putExternalEvaluation(request))
  def getConformancePackComplianceSummary(
      request: zio.aws.config.model.GetConformancePackComplianceSummaryRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.getConformancePackComplianceSummary(request))
  def getConformancePackComplianceSummaryPaginated(
      request: zio.aws.config.model.GetConformancePackComplianceSummaryRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.getConformancePackComplianceSummaryPaginated(request))
  def deleteConfigRule(
      request: zio.aws.config.model.DeleteConfigRuleRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConfigRule(request))
  def describeConfigurationRecorders(
      request: zio.aws.config.model.DescribeConfigurationRecordersRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationRecorders(request))
  def selectAggregateResourceConfig(
      request: zio.aws.config.model.SelectAggregateResourceConfigRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly,
    String
  ]] = ZIO.serviceWithZIO(_.selectAggregateResourceConfig(request))
  def selectAggregateResourceConfigPaginated(
      request: zio.aws.config.model.SelectAggregateResourceConfigRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.selectAggregateResourceConfigPaginated(request))
  def describeOrganizationConformancePacks(
      request: zio.aws.config.model.DescribeOrganizationConformancePacksRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.OrganizationConformancePack.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOrganizationConformancePacks(request))
  def describeOrganizationConformancePacksPaginated(
      request: zio.aws.config.model.DescribeOrganizationConformancePacksRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeOrganizationConformancePacksPaginated(request))
  def getStoredQuery(request: zio.aws.config.model.GetStoredQueryRequest): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetStoredQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStoredQuery(request))
  def deletePendingAggregationRequest(
      request: zio.aws.config.model.DeletePendingAggregationRequestRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePendingAggregationRequest(request))
  def getCustomRulePolicy(
      request: zio.aws.config.model.GetCustomRulePolicyRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCustomRulePolicy(request))
  def startConfigurationRecorder(
      request: zio.aws.config.model.StartConfigurationRecorderRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startConfigurationRecorder(request))
  def putStoredQuery(request: zio.aws.config.model.PutStoredQueryRequest): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutStoredQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putStoredQuery(request))
  def getComplianceSummaryByResourceType(
      request: zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComplianceSummaryByResourceType(request))
  def describeConfigRules(
      request: zio.aws.config.model.DescribeConfigRulesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConfigRule.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConfigRules(request))
  def describeConfigRulesPaginated(
      request: zio.aws.config.model.DescribeConfigRulesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigRulesPaginated(request))
  def describeConformancePacks(
      request: zio.aws.config.model.DescribeConformancePacksRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConformancePackDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConformancePacks(request))
  def describeConformancePacksPaginated(
      request: zio.aws.config.model.DescribeConformancePacksRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConformancePacksPaginated(request))
  def getAggregateResourceConfig(
      request: zio.aws.config.model.GetAggregateResourceConfigRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAggregateResourceConfig(request))
  def getAggregateDiscoveredResourceCounts(
      request: zio.aws.config.model.GetAggregateDiscoveredResourceCountsRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly,
    zio.aws.config.model.GroupedResourceCount.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getAggregateDiscoveredResourceCounts(request))
  def getAggregateDiscoveredResourceCountsPaginated(
      request: zio.aws.config.model.GetAggregateDiscoveredResourceCountsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.getAggregateDiscoveredResourceCountsPaginated(request))
  def describeConformancePackCompliance(
      request: zio.aws.config.model.DescribeConformancePackComplianceRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly,
    zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeConformancePackCompliance(request))
  def describeConformancePackCompliancePaginated(
      request: zio.aws.config.model.DescribeConformancePackComplianceRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConformancePackCompliancePaginated(request))
  def describeComplianceByResource(
      request: zio.aws.config.model.DescribeComplianceByResourceRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ComplianceByResource.ReadOnly
  ] = ZStream.serviceWithStream(_.describeComplianceByResource(request))
  def describeComplianceByResourcePaginated(
      request: zio.aws.config.model.DescribeComplianceByResourceRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeComplianceByResourcePaginated(request))
  def putRemediationConfigurations(
      request: zio.aws.config.model.PutRemediationConfigurationsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRemediationConfigurations(request))
  def untagResource(
      request: zio.aws.config.model.UntagResourceRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def describeAggregateComplianceByConformancePacks(
      request: zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeAggregateComplianceByConformancePacks(request)
  )
  def describeAggregateComplianceByConformancePacksPaginated(
      request: zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeAggregateComplianceByConformancePacksPaginated(request)
  )
  def getResourceConfigHistory(
      request: zio.aws.config.model.GetResourceConfigHistoryRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConfigurationItem.ReadOnly
  ] = ZStream.serviceWithStream(_.getResourceConfigHistory(request))
  def getResourceConfigHistoryPaginated(
      request: zio.aws.config.model.GetResourceConfigHistoryRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceConfigHistoryPaginated(request))
  def describeRetentionConfigurations(
      request: zio.aws.config.model.DescribeRetentionConfigurationsRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.RetentionConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRetentionConfigurations(request))
  def describeRetentionConfigurationsPaginated(
      request: zio.aws.config.model.DescribeRetentionConfigurationsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRetentionConfigurationsPaginated(request))
  def putOrganizationConformancePack(
      request: zio.aws.config.model.PutOrganizationConformancePackRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putOrganizationConformancePack(request))
  def listConformancePackComplianceScores(
      request: zio.aws.config.model.ListConformancePackComplianceScoresRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConformancePackComplianceScore.ReadOnly
  ] = ZStream.serviceWithStream(_.listConformancePackComplianceScores(request))
  def listConformancePackComplianceScoresPaginated(
      request: zio.aws.config.model.ListConformancePackComplianceScoresRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listConformancePackComplianceScoresPaginated(request))
  def putOrganizationConfigRule(
      request: zio.aws.config.model.PutOrganizationConfigRuleRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putOrganizationConfigRule(request))
  def putResourceConfig(
      request: zio.aws.config.model.PutResourceConfigRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putResourceConfig(request))
  def describeConfigurationAggregatorSourcesStatus(
      request: zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.AggregatedSourceStatus.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeConfigurationAggregatorSourcesStatus(request)
  )
  def describeConfigurationAggregatorSourcesStatusPaginated(
      request: zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeConfigurationAggregatorSourcesStatusPaginated(request)
  )
  def deleteConfigurationAggregator(
      request: zio.aws.config.model.DeleteConfigurationAggregatorRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConfigurationAggregator(request))
  def describeConformancePackStatus(
      request: zio.aws.config.model.DescribeConformancePackStatusRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ConformancePackStatusDetail.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConformancePackStatus(request))
  def describeConformancePackStatusPaginated(
      request: zio.aws.config.model.DescribeConformancePackStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConformancePackStatusPaginated(request))
  def putConformancePack(
      request: zio.aws.config.model.PutConformancePackRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutConformancePackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConformancePack(request))
  def deleteAggregationAuthorization(
      request: zio.aws.config.model.DeleteAggregationAuthorizationRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAggregationAuthorization(request))
  def startResourceEvaluation(
      request: zio.aws.config.model.StartResourceEvaluationRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.StartResourceEvaluationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startResourceEvaluation(request))
  def putEvaluations(request: zio.aws.config.model.PutEvaluationsRequest): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutEvaluationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEvaluations(request))
  def deleteDeliveryChannel(
      request: zio.aws.config.model.DeleteDeliveryChannelRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDeliveryChannel(request))
  def putConfigRule(
      request: zio.aws.config.model.PutConfigRuleRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putConfigRule(request))
  def listTagsForResource(
      request: zio.aws.config.model.ListTagsForResourceRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.config.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def getOrganizationConformancePackDetailedStatus(
      request: zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getOrganizationConformancePackDetailedStatus(request)
  )
  def getOrganizationConformancePackDetailedStatusPaginated(
      request: zio.aws.config.model.GetOrganizationConformancePackDetailedStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getOrganizationConformancePackDetailedStatusPaginated(request)
  )
  def tagResource(
      request: zio.aws.config.model.TagResourceRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def deleteStoredQuery(
      request: zio.aws.config.model.DeleteStoredQueryRequest
  ): ZIO[zio.aws.config.Config, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteStoredQuery(request))
  def getComplianceDetailsByConfigRule(
      request: zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.EvaluationResult.ReadOnly
  ] = ZStream.serviceWithStream(_.getComplianceDetailsByConfigRule(request))
  def getComplianceDetailsByConfigRulePaginated(
      request: zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComplianceDetailsByConfigRulePaginated(request))
  def startRemediationExecution(
      request: zio.aws.config.model.StartRemediationExecutionRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startRemediationExecution(request))
  def getConformancePackComplianceDetails(
      request: zio.aws.config.model.GetConformancePackComplianceDetailsRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly,
    zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getConformancePackComplianceDetails(request))
  def getConformancePackComplianceDetailsPaginated(
      request: zio.aws.config.model.GetConformancePackComplianceDetailsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.getConformancePackComplianceDetailsPaginated(request))
  def selectResourceConfig(
      request: zio.aws.config.model.SelectResourceConfigRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.SelectResourceConfigResponse.ReadOnly,
    String
  ]] = ZIO.serviceWithZIO(_.selectResourceConfig(request))
  def selectResourceConfigPaginated(
      request: zio.aws.config.model.SelectResourceConfigRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.SelectResourceConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.selectResourceConfigPaginated(request))
  def describeRemediationExecutionStatus(
      request: zio.aws.config.model.DescribeRemediationExecutionStatusRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.RemediationExecutionStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeRemediationExecutionStatus(request))
  def describeRemediationExecutionStatusPaginated(
      request: zio.aws.config.model.DescribeRemediationExecutionStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRemediationExecutionStatusPaginated(request))
  def describeConfigurationRecorderStatus(
      request: zio.aws.config.model.DescribeConfigurationRecorderStatusRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationRecorderStatus(request))
  def getOrganizationCustomRulePolicy(
      request: zio.aws.config.model.GetOrganizationCustomRulePolicyRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOrganizationCustomRulePolicy(request))
  def getAggregateComplianceDetailsByConfigRule(
      request: zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.AggregateEvaluationResult.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getAggregateComplianceDetailsByConfigRule(request)
  )
  def getAggregateComplianceDetailsByConfigRulePaginated(
      request: zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getAggregateComplianceDetailsByConfigRulePaginated(request)
  )
  def putAggregationAuthorization(
      request: zio.aws.config.model.PutAggregationAuthorizationRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAggregationAuthorization(request))
  def getAggregateConformancePackComplianceSummary(
      request: zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ): ZIO[zio.aws.config.Config, AwsError, StreamingOutputResult[
    Any,
    zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly,
    zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
  ]] =
    ZIO.serviceWithZIO(_.getAggregateConformancePackComplianceSummary(request))
  def getAggregateConformancePackComplianceSummaryPaginated(
      request: zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getAggregateConformancePackComplianceSummaryPaginated(request)
  )
  def deleteRemediationConfiguration(
      request: zio.aws.config.model.DeleteRemediationConfigurationRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DeleteRemediationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRemediationConfiguration(request))
  def describeOrganizationConfigRules(
      request: zio.aws.config.model.DescribeOrganizationConfigRulesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.OrganizationConfigRule.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOrganizationConfigRules(request))
  def describeOrganizationConfigRulesPaginated(
      request: zio.aws.config.model.DescribeOrganizationConfigRulesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationConfigRulesPaginated(request))
  def deleteConfigurationRecorder(
      request: zio.aws.config.model.DeleteConfigurationRecorderRequest
  ): ZIO[zio.aws.config.Config, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConfigurationRecorder(request))
  def listResourceEvaluations(
      request: zio.aws.config.model.ListResourceEvaluationsRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ResourceEvaluation.ReadOnly
  ] = ZStream.serviceWithStream(_.listResourceEvaluations(request))
  def listResourceEvaluationsPaginated(
      request: zio.aws.config.model.ListResourceEvaluationsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ListResourceEvaluationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceEvaluationsPaginated(request))
  def batchGetResourceConfig(
      request: zio.aws.config.model.BatchGetResourceConfigRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetResourceConfig(request))
  def batchGetAggregateResourceConfig(
      request: zio.aws.config.model.BatchGetAggregateResourceConfigRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetAggregateResourceConfig(request))
  def listDiscoveredResources(
      request: zio.aws.config.model.ListDiscoveredResourcesRequest
  ): ZStream[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ResourceIdentifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listDiscoveredResources(request))
  def listDiscoveredResourcesPaginated(
      request: zio.aws.config.model.ListDiscoveredResourcesRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDiscoveredResourcesPaginated(request))
  def getDiscoveredResourceCounts(
      request: zio.aws.config.model.GetDiscoveredResourceCountsRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDiscoveredResourceCounts(request))
  def deliverConfigSnapshot(
      request: zio.aws.config.model.DeliverConfigSnapshotRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deliverConfigSnapshot(request))
  def putRetentionConfiguration(
      request: zio.aws.config.model.PutRetentionConfigurationRequest
  ): ZIO[
    zio.aws.config.Config,
    AwsError,
    zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRetentionConfiguration(request))
}
