package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregateConformancePackCompliance(
    complianceType: Optional[
      zio.aws.config.model.ConformancePackComplianceType
    ] = Optional.Absent,
    compliantRuleCount: Optional[Integer] = Optional.Absent,
    nonCompliantRuleCount: Optional[Integer] = Optional.Absent,
    totalRuleCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance = {
    import AggregateConformancePackCompliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
      .builder()
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        compliantRuleCount.map(value => value: java.lang.Integer)
      )(_.compliantRuleCount)
      .optionallyWith(
        nonCompliantRuleCount.map(value => value: java.lang.Integer)
      )(_.nonCompliantRuleCount)
      .optionallyWith(totalRuleCount.map(value => value: java.lang.Integer))(
        _.totalRuleCount
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly =
    zio.aws.config.model.AggregateConformancePackCompliance
      .wrap(buildAwsValue())
}
object AggregateConformancePackCompliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateConformancePackCompliance =
      zio.aws.config.model.AggregateConformancePackCompliance(
        complianceType.map(value => value),
        compliantRuleCount.map(value => value),
        nonCompliantRuleCount.map(value => value),
        totalRuleCount.map(value => value)
      )
    def complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType]
    def compliantRuleCount: Optional[Integer]
    def nonCompliantRuleCount: Optional[Integer]
    def totalRuleCount: Optional[Integer]
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
    def getCompliantRuleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("compliantRuleCount", compliantRuleCount)
    def getNonCompliantRuleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nonCompliantRuleCount", nonCompliantRuleCount)
    def getTotalRuleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalRuleCount", totalRuleCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
  ) extends zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly {
    override val complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.config.model.ConformancePackComplianceType.wrap(value)
        )
    override val compliantRuleCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.compliantRuleCount())
      .map(value => value: Integer)
    override val nonCompliantRuleCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantRuleCount())
        .map(value => value: Integer)
    override val totalRuleCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalRuleCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackCompliance
  ): zio.aws.config.model.AggregateConformancePackCompliance.ReadOnly =
    new Wrapper(impl)
}
