package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  AwsRegion,
  AccountId,
  ConformancePackName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregateConformancePackComplianceFilters(
    conformancePackName: Optional[ConformancePackName] = Optional.Absent,
    complianceType: Optional[
      zio.aws.config.model.ConformancePackComplianceType
    ] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceFilters = {
    import AggregateConformancePackComplianceFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceFilters
      .builder()
      .optionallyWith(
        conformancePackName.map(value =>
          ConformancePackName.unwrap(value): java.lang.String
        )
      )(_.conformancePackName)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateConformancePackComplianceFilters.ReadOnly =
    zio.aws.config.model.AggregateConformancePackComplianceFilters
      .wrap(buildAwsValue())
}
object AggregateConformancePackComplianceFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.AggregateConformancePackComplianceFilters =
      zio.aws.config.model.AggregateConformancePackComplianceFilters(
        conformancePackName.map(value => value),
        complianceType.map(value => value),
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def conformancePackName: Optional[ConformancePackName]
    def complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType]
    def accountId: Optional[AccountId]
    def awsRegion: Optional[AwsRegion]
    def getConformancePackName: ZIO[Any, AwsError, ConformancePackName] =
      AwsError.unwrapOptionField("conformancePackName", conformancePackName)
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceFilters
  ) extends zio.aws.config.model.AggregateConformancePackComplianceFilters.ReadOnly {
    override val conformancePackName: Optional[ConformancePackName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conformancePackName())
        .map(value =>
          zio.aws.config.model.primitives.ConformancePackName(value)
        )
    override val complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.config.model.ConformancePackComplianceType.wrap(value)
        )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceFilters
  ): zio.aws.config.model.AggregateConformancePackComplianceFilters.ReadOnly =
    new Wrapper(impl)
}
