package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  ConfigurationStateId,
  AccountId,
  AvailabilityZone,
  SupplementaryConfigurationName,
  Version,
  Configuration,
  ResourceCreationTime,
  AwsRegion,
  ConfigurationItemCaptureTime,
  SupplementaryConfigurationValue,
  ResourceId,
  ResourceName,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BaseConfigurationItem(
    version: Optional[Version] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    configurationItemCaptureTime: Optional[ConfigurationItemCaptureTime] =
      Optional.Absent,
    configurationItemStatus: Optional[
      zio.aws.config.model.ConfigurationItemStatus
    ] = Optional.Absent,
    configurationStateId: Optional[ConfigurationStateId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[zio.aws.config.model.ResourceType] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent,
    availabilityZone: Optional[AvailabilityZone] = Optional.Absent,
    resourceCreationTime: Optional[ResourceCreationTime] = Optional.Absent,
    configuration: Optional[Configuration] = Optional.Absent,
    supplementaryConfiguration: Optional[
      Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.BaseConfigurationItem = {
    import BaseConfigurationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.BaseConfigurationItem
      .builder()
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        configurationItemCaptureTime.map(value =>
          ConfigurationItemCaptureTime.unwrap(value): Instant
        )
      )(_.configurationItemCaptureTime)
      .optionallyWith(configurationItemStatus.map(value => value.unwrap))(
        _.configurationItemStatus
      )
      .optionallyWith(
        configurationStateId.map(value =>
          ConfigurationStateId.unwrap(value): java.lang.String
        )
      )(_.configurationStateId)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZone.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        resourceCreationTime.map(value =>
          ResourceCreationTime.unwrap(value): Instant
        )
      )(_.resourceCreationTime)
      .optionallyWith(
        configuration.map(value =>
          Configuration.unwrap(value): java.lang.String
        )
      )(_.configuration)
      .optionallyWith(
        supplementaryConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (SupplementaryConfigurationName.unwrap(
                key
              ): java.lang.String) -> (SupplementaryConfigurationValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.supplementaryConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.config.model.BaseConfigurationItem.ReadOnly =
    zio.aws.config.model.BaseConfigurationItem.wrap(buildAwsValue())
}
object BaseConfigurationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.BaseConfigurationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.BaseConfigurationItem =
      zio.aws.config.model.BaseConfigurationItem(
        version.map(value => value),
        accountId.map(value => value),
        configurationItemCaptureTime.map(value => value),
        configurationItemStatus.map(value => value),
        configurationStateId.map(value => value),
        arn.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        awsRegion.map(value => value),
        availabilityZone.map(value => value),
        resourceCreationTime.map(value => value),
        configuration.map(value => value),
        supplementaryConfiguration.map(value => value)
      )
    def version: Optional[Version]
    def accountId: Optional[AccountId]
    def configurationItemCaptureTime: Optional[ConfigurationItemCaptureTime]
    def configurationItemStatus
        : Optional[zio.aws.config.model.ConfigurationItemStatus]
    def configurationStateId: Optional[ConfigurationStateId]
    def arn: Optional[ARN]
    def resourceType: Optional[zio.aws.config.model.ResourceType]
    def resourceId: Optional[ResourceId]
    def resourceName: Optional[ResourceName]
    def awsRegion: Optional[AwsRegion]
    def availabilityZone: Optional[AvailabilityZone]
    def resourceCreationTime: Optional[ResourceCreationTime]
    def configuration: Optional[Configuration]
    def supplementaryConfiguration: Optional[
      Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
    ]
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getConfigurationItemCaptureTime
        : ZIO[Any, AwsError, ConfigurationItemCaptureTime] =
      AwsError.unwrapOptionField(
        "configurationItemCaptureTime",
        configurationItemCaptureTime
      )
    def getConfigurationItemStatus
        : ZIO[Any, AwsError, zio.aws.config.model.ConfigurationItemStatus] =
      AwsError.unwrapOptionField(
        "configurationItemStatus",
        configurationItemStatus
      )
    def getConfigurationStateId: ZIO[Any, AwsError, ConfigurationStateId] =
      AwsError.unwrapOptionField("configurationStateId", configurationStateId)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZone] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getResourceCreationTime: ZIO[Any, AwsError, ResourceCreationTime] =
      AwsError.unwrapOptionField("resourceCreationTime", resourceCreationTime)
    def getConfiguration: ZIO[Any, AwsError, Configuration] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getSupplementaryConfiguration: ZIO[Any, AwsError, Map[
      SupplementaryConfigurationName,
      SupplementaryConfigurationValue
    ]] = AwsError.unwrapOptionField(
      "supplementaryConfiguration",
      supplementaryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.BaseConfigurationItem
  ) extends zio.aws.config.model.BaseConfigurationItem.ReadOnly {
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.config.model.primitives.Version(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val configurationItemCaptureTime
        : Optional[ConfigurationItemCaptureTime] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationItemCaptureTime())
      .map(value =>
        zio.aws.config.model.primitives.ConfigurationItemCaptureTime(value)
      )
    override val configurationItemStatus
        : Optional[zio.aws.config.model.ConfigurationItemStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationItemStatus())
        .map(value => zio.aws.config.model.ConfigurationItemStatus.wrap(value))
    override val configurationStateId: Optional[ConfigurationStateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationStateId())
        .map(value =>
          zio.aws.config.model.primitives.ConfigurationStateId(value)
        )
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.config.model.primitives.ARN(value))
    override val resourceType: Optional[zio.aws.config.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.ResourceId(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
    override val availabilityZone: Optional[AvailabilityZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value => zio.aws.config.model.primitives.AvailabilityZone(value))
    override val resourceCreationTime: Optional[ResourceCreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCreationTime())
        .map(value =>
          zio.aws.config.model.primitives.ResourceCreationTime(value)
        )
    override val configuration: Optional[Configuration] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value => zio.aws.config.model.primitives.Configuration(value))
    override val supplementaryConfiguration: Optional[
      Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementaryConfiguration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.config.model.primitives.SupplementaryConfigurationName(
              key
            ) -> zio.aws.config.model.primitives
              .SupplementaryConfigurationValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.BaseConfigurationItem
  ): zio.aws.config.model.BaseConfigurationItem.ReadOnly = new Wrapper(impl)
}
