package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetAggregateResourceConfigResponse(
    baseConfigurationItems: Optional[
      Iterable[zio.aws.config.model.BaseConfigurationItem]
    ] = Optional.Absent,
    unprocessedResourceIdentifiers: Optional[
      Iterable[zio.aws.config.model.AggregateResourceIdentifier]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse = {
    import BatchGetAggregateResourceConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse
      .builder()
      .optionallyWith(
        baseConfigurationItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baseConfigurationItems)
      .optionallyWith(
        unprocessedResourceIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedResourceIdentifiers)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly =
    zio.aws.config.model.BatchGetAggregateResourceConfigResponse
      .wrap(buildAwsValue())
}
object BatchGetAggregateResourceConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.BatchGetAggregateResourceConfigResponse =
      zio.aws.config.model.BatchGetAggregateResourceConfigResponse(
        baseConfigurationItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedResourceIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def baseConfigurationItems
        : Optional[List[zio.aws.config.model.BaseConfigurationItem.ReadOnly]]
    def unprocessedResourceIdentifiers: Optional[
      List[zio.aws.config.model.AggregateResourceIdentifier.ReadOnly]
    ]
    def getBaseConfigurationItems: ZIO[Any, AwsError, List[
      zio.aws.config.model.BaseConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "baseConfigurationItems",
      baseConfigurationItems
    )
    def getUnprocessedResourceIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedResourceIdentifiers",
      unprocessedResourceIdentifiers
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse
  ) extends zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly {
    override val baseConfigurationItems
        : Optional[List[zio.aws.config.model.BaseConfigurationItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseConfigurationItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.BaseConfigurationItem.wrap(item)
          }.toList
        )
    override val unprocessedResourceIdentifiers: Optional[
      List[zio.aws.config.model.AggregateResourceIdentifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.unprocessedResourceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateResourceIdentifier.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse
  ): zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly =
    new Wrapper(impl)
}
