package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit64
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComplianceByConfigRule(
    configRuleName: Optional[StringWithCharLimit64] = Optional.Absent,
    compliance: Optional[zio.aws.config.model.Compliance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceByConfigRule = {
    import ComplianceByConfigRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceByConfigRule
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          StringWithCharLimit64.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceByConfigRule.ReadOnly =
    zio.aws.config.model.ComplianceByConfigRule.wrap(buildAwsValue())
}
object ComplianceByConfigRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceByConfigRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceByConfigRule =
      zio.aws.config.model.ComplianceByConfigRule(
        configRuleName.map(value => value),
        compliance.map(value => value.asEditable)
      )
    def configRuleName: Optional[StringWithCharLimit64]
    def compliance: Optional[zio.aws.config.model.Compliance.ReadOnly]
    def getConfigRuleName: ZIO[Any, AwsError, StringWithCharLimit64] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getCompliance
        : ZIO[Any, AwsError, zio.aws.config.model.Compliance.ReadOnly] =
      AwsError.unwrapOptionField("compliance", compliance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceByConfigRule
  ) extends zio.aws.config.model.ComplianceByConfigRule.ReadOnly {
    override val configRuleName: Optional[StringWithCharLimit64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit64(value)
        )
    override val compliance
        : Optional[zio.aws.config.model.Compliance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliance())
        .map(value => zio.aws.config.model.Compliance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceByConfigRule
  ): zio.aws.config.model.ComplianceByConfigRule.ReadOnly = new Wrapper(impl)
}
