package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{BaseResourceId, StringWithCharLimit256}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComplianceByResource(
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    resourceId: Optional[BaseResourceId] = Optional.Absent,
    compliance: Optional[zio.aws.config.model.Compliance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceByResource = {
    import ComplianceByResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceByResource
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(compliance.map(value => value.buildAwsValue()))(
        _.compliance
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceByResource.ReadOnly =
    zio.aws.config.model.ComplianceByResource.wrap(buildAwsValue())
}
object ComplianceByResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceByResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceByResource =
      zio.aws.config.model.ComplianceByResource(
        resourceType.map(value => value),
        resourceId.map(value => value),
        compliance.map(value => value.asEditable)
      )
    def resourceType: Optional[StringWithCharLimit256]
    def resourceId: Optional[BaseResourceId]
    def compliance: Optional[zio.aws.config.model.Compliance.ReadOnly]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getCompliance
        : ZIO[Any, AwsError, zio.aws.config.model.Compliance.ReadOnly] =
      AwsError.unwrapOptionField("compliance", compliance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceByResource
  ) extends zio.aws.config.model.ComplianceByResource.ReadOnly {
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val resourceId: Optional[BaseResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
    override val compliance
        : Optional[zio.aws.config.model.Compliance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliance())
        .map(value => zio.aws.config.model.Compliance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceByResource
  ): zio.aws.config.model.ComplianceByResource.ReadOnly = new Wrapper(impl)
}
