package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Date, ConfigRuleName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigRuleEvaluationStatus(
    configRuleName: Optional[ConfigRuleName] = Optional.Absent,
    configRuleArn: Optional[String] = Optional.Absent,
    configRuleId: Optional[String] = Optional.Absent,
    lastSuccessfulInvocationTime: Optional[Date] = Optional.Absent,
    lastFailedInvocationTime: Optional[Date] = Optional.Absent,
    lastSuccessfulEvaluationTime: Optional[Date] = Optional.Absent,
    lastFailedEvaluationTime: Optional[Date] = Optional.Absent,
    firstActivatedTime: Optional[Date] = Optional.Absent,
    lastDeactivatedTime: Optional[Date] = Optional.Absent,
    lastErrorCode: Optional[String] = Optional.Absent,
    lastErrorMessage: Optional[String] = Optional.Absent,
    firstEvaluationStarted: Optional[Boolean] = Optional.Absent,
    lastDebugLogDeliveryStatus: Optional[String] = Optional.Absent,
    lastDebugLogDeliveryStatusReason: Optional[String] = Optional.Absent,
    lastDebugLogDeliveryTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus = {
    import ConfigRuleEvaluationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(configRuleArn.map(value => value: java.lang.String))(
        _.configRuleArn
      )
      .optionallyWith(configRuleId.map(value => value: java.lang.String))(
        _.configRuleId
      )
      .optionallyWith(
        lastSuccessfulInvocationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastSuccessfulInvocationTime)
      .optionallyWith(
        lastFailedInvocationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastFailedInvocationTime)
      .optionallyWith(
        lastSuccessfulEvaluationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastSuccessfulEvaluationTime)
      .optionallyWith(
        lastFailedEvaluationTime.map(value => Date.unwrap(value): Instant)
      )(_.lastFailedEvaluationTime)
      .optionallyWith(
        firstActivatedTime.map(value => Date.unwrap(value): Instant)
      )(_.firstActivatedTime)
      .optionallyWith(
        lastDeactivatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastDeactivatedTime)
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .optionallyWith(
        firstEvaluationStarted.map(value => value: java.lang.Boolean)
      )(_.firstEvaluationStarted)
      .optionallyWith(
        lastDebugLogDeliveryStatus.map(value => value: java.lang.String)
      )(_.lastDebugLogDeliveryStatus)
      .optionallyWith(
        lastDebugLogDeliveryStatusReason.map(value => value: java.lang.String)
      )(_.lastDebugLogDeliveryStatusReason)
      .optionallyWith(
        lastDebugLogDeliveryTime.map(value => Date.unwrap(value): Instant)
      )(_.lastDebugLogDeliveryTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly =
    zio.aws.config.model.ConfigRuleEvaluationStatus.wrap(buildAwsValue())
}
object ConfigRuleEvaluationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRuleEvaluationStatus =
      zio.aws.config.model.ConfigRuleEvaluationStatus(
        configRuleName.map(value => value),
        configRuleArn.map(value => value),
        configRuleId.map(value => value),
        lastSuccessfulInvocationTime.map(value => value),
        lastFailedInvocationTime.map(value => value),
        lastSuccessfulEvaluationTime.map(value => value),
        lastFailedEvaluationTime.map(value => value),
        firstActivatedTime.map(value => value),
        lastDeactivatedTime.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value),
        firstEvaluationStarted.map(value => value),
        lastDebugLogDeliveryStatus.map(value => value),
        lastDebugLogDeliveryStatusReason.map(value => value),
        lastDebugLogDeliveryTime.map(value => value)
      )
    def configRuleName: Optional[ConfigRuleName]
    def configRuleArn: Optional[String]
    def configRuleId: Optional[String]
    def lastSuccessfulInvocationTime: Optional[Date]
    def lastFailedInvocationTime: Optional[Date]
    def lastSuccessfulEvaluationTime: Optional[Date]
    def lastFailedEvaluationTime: Optional[Date]
    def firstActivatedTime: Optional[Date]
    def lastDeactivatedTime: Optional[Date]
    def lastErrorCode: Optional[String]
    def lastErrorMessage: Optional[String]
    def firstEvaluationStarted: Optional[Boolean]
    def lastDebugLogDeliveryStatus: Optional[String]
    def lastDebugLogDeliveryStatusReason: Optional[String]
    def lastDebugLogDeliveryTime: Optional[Date]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getConfigRuleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configRuleArn", configRuleArn)
    def getConfigRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configRuleId", configRuleId)
    def getLastSuccessfulInvocationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "lastSuccessfulInvocationTime",
        lastSuccessfulInvocationTime
      )
    def getLastFailedInvocationTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastFailedInvocationTime", lastFailedInvocationTime)
    def getLastSuccessfulEvaluationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "lastSuccessfulEvaluationTime",
        lastSuccessfulEvaluationTime
      )
    def getLastFailedEvaluationTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastFailedEvaluationTime", lastFailedEvaluationTime)
    def getFirstActivatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("firstActivatedTime", firstActivatedTime)
    def getLastDeactivatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastDeactivatedTime", lastDeactivatedTime)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
    def getFirstEvaluationStarted: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("firstEvaluationStarted", firstEvaluationStarted)
    def getLastDebugLogDeliveryStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "lastDebugLogDeliveryStatus",
        lastDebugLogDeliveryStatus
      )
    def getLastDebugLogDeliveryStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "lastDebugLogDeliveryStatusReason",
        lastDebugLogDeliveryStatusReason
      )
    def getLastDebugLogDeliveryTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastDebugLogDeliveryTime", lastDebugLogDeliveryTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
  ) extends zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly {
    override val configRuleName: Optional[ConfigRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val configRuleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configRuleArn())
      .map(value => value: String)
    override val configRuleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configRuleId())
      .map(value => value: String)
    override val lastSuccessfulInvocationTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulInvocationTime())
        .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastFailedInvocationTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastFailedInvocationTime())
        .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastSuccessfulEvaluationTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulEvaluationTime())
        .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastFailedEvaluationTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastFailedEvaluationTime())
        .map(value => zio.aws.config.model.primitives.Date(value))
    override val firstActivatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.firstActivatedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastDeactivatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDeactivatedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastErrorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorCode())
      .map(value => value: String)
    override val lastErrorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorMessage())
      .map(value => value: String)
    override val firstEvaluationStarted: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstEvaluationStarted())
        .map(value => value: Boolean)
    override val lastDebugLogDeliveryStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDebugLogDeliveryStatus())
        .map(value => value: String)
    override val lastDebugLogDeliveryStatusReason: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDebugLogDeliveryStatusReason())
        .map(value => value: String)
    override val lastDebugLogDeliveryTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDebugLogDeliveryTime())
        .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus
  ): zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly = new Wrapper(
    impl
  )
}
