package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigStreamDeliveryInfo(
    lastStatus: Optional[zio.aws.config.model.DeliveryStatus] = Optional.Absent,
    lastErrorCode: Optional[String] = Optional.Absent,
    lastErrorMessage: Optional[String] = Optional.Absent,
    lastStatusChangeTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo = {
    import ConfigStreamDeliveryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo
      .builder()
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .optionallyWith(
        lastStatusChangeTime.map(value => Date.unwrap(value): Instant)
      )(_.lastStatusChangeTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigStreamDeliveryInfo.ReadOnly =
    zio.aws.config.model.ConfigStreamDeliveryInfo.wrap(buildAwsValue())
}
object ConfigStreamDeliveryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigStreamDeliveryInfo =
      zio.aws.config.model.ConfigStreamDeliveryInfo(
        lastStatus.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value),
        lastStatusChangeTime.map(value => value)
      )
    def lastStatus: Optional[zio.aws.config.model.DeliveryStatus]
    def lastErrorCode: Optional[String]
    def lastErrorMessage: Optional[String]
    def lastStatusChangeTime: Optional[Date]
    def getLastStatus: ZIO[Any, AwsError, zio.aws.config.model.DeliveryStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
    def getLastStatusChangeTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStatusChangeTime", lastStatusChangeTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo
  ) extends zio.aws.config.model.ConfigStreamDeliveryInfo.ReadOnly {
    override val lastStatus: Optional[zio.aws.config.model.DeliveryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStatus())
        .map(value => zio.aws.config.model.DeliveryStatus.wrap(value))
    override val lastErrorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorCode())
      .map(value => value: String)
    override val lastErrorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorMessage())
      .map(value => value: String)
    override val lastStatusChangeTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChangeTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigStreamDeliveryInfo
  ): zio.aws.config.model.ConfigStreamDeliveryInfo.ReadOnly = new Wrapper(impl)
}
