package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  RelatedEvent,
  ConfigurationStateId,
  AccountId,
  AvailabilityZone,
  SupplementaryConfigurationName,
  Value,
  Version,
  Configuration,
  ResourceCreationTime,
  AwsRegion,
  ConfigurationItemMD5Hash,
  ConfigurationItemCaptureTime,
  Name,
  SupplementaryConfigurationValue,
  ResourceId,
  ResourceName,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigurationItem(
    version: Optional[Version] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    configurationItemCaptureTime: Optional[ConfigurationItemCaptureTime] =
      Optional.Absent,
    configurationItemStatus: Optional[
      zio.aws.config.model.ConfigurationItemStatus
    ] = Optional.Absent,
    configurationStateId: Optional[ConfigurationStateId] = Optional.Absent,
    configurationItemMD5Hash: Optional[ConfigurationItemMD5Hash] =
      Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[zio.aws.config.model.ResourceType] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent,
    availabilityZone: Optional[AvailabilityZone] = Optional.Absent,
    resourceCreationTime: Optional[ResourceCreationTime] = Optional.Absent,
    tags: Optional[Map[Name, Value]] = Optional.Absent,
    relatedEvents: Optional[Iterable[RelatedEvent]] = Optional.Absent,
    relationships: Optional[Iterable[zio.aws.config.model.Relationship]] =
      Optional.Absent,
    configuration: Optional[Configuration] = Optional.Absent,
    supplementaryConfiguration: Optional[
      Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigurationItem = {
    import ConfigurationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigurationItem
      .builder()
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        configurationItemCaptureTime.map(value =>
          ConfigurationItemCaptureTime.unwrap(value): Instant
        )
      )(_.configurationItemCaptureTime)
      .optionallyWith(configurationItemStatus.map(value => value.unwrap))(
        _.configurationItemStatus
      )
      .optionallyWith(
        configurationStateId.map(value =>
          ConfigurationStateId.unwrap(value): java.lang.String
        )
      )(_.configurationStateId)
      .optionallyWith(
        configurationItemMD5Hash.map(value =>
          ConfigurationItemMD5Hash.unwrap(value): java.lang.String
        )
      )(_.configurationItemMD5Hash)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZone.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        resourceCreationTime.map(value =>
          ResourceCreationTime.unwrap(value): Instant
        )
      )(_.resourceCreationTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (Value.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        relatedEvents.map(value =>
          value.map { item =>
            RelatedEvent.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedEvents)
      .optionallyWith(
        relationships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationships)
      .optionallyWith(
        configuration.map(value =>
          Configuration.unwrap(value): java.lang.String
        )
      )(_.configuration)
      .optionallyWith(
        supplementaryConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (SupplementaryConfigurationName.unwrap(
                key
              ): java.lang.String) -> (SupplementaryConfigurationValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.supplementaryConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigurationItem.ReadOnly =
    zio.aws.config.model.ConfigurationItem.wrap(buildAwsValue())
}
object ConfigurationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigurationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigurationItem =
      zio.aws.config.model.ConfigurationItem(
        version.map(value => value),
        accountId.map(value => value),
        configurationItemCaptureTime.map(value => value),
        configurationItemStatus.map(value => value),
        configurationStateId.map(value => value),
        configurationItemMD5Hash.map(value => value),
        arn.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        awsRegion.map(value => value),
        availabilityZone.map(value => value),
        resourceCreationTime.map(value => value),
        tags.map(value => value),
        relatedEvents.map(value => value),
        relationships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value),
        supplementaryConfiguration.map(value => value)
      )
    def version: Optional[Version]
    def accountId: Optional[AccountId]
    def configurationItemCaptureTime: Optional[ConfigurationItemCaptureTime]
    def configurationItemStatus
        : Optional[zio.aws.config.model.ConfigurationItemStatus]
    def configurationStateId: Optional[ConfigurationStateId]
    def configurationItemMD5Hash: Optional[ConfigurationItemMD5Hash]
    def arn: Optional[ARN]
    def resourceType: Optional[zio.aws.config.model.ResourceType]
    def resourceId: Optional[ResourceId]
    def resourceName: Optional[ResourceName]
    def awsRegion: Optional[AwsRegion]
    def availabilityZone: Optional[AvailabilityZone]
    def resourceCreationTime: Optional[ResourceCreationTime]
    def tags: Optional[Map[Name, Value]]
    def relatedEvents: Optional[List[RelatedEvent]]
    def relationships
        : Optional[List[zio.aws.config.model.Relationship.ReadOnly]]
    def configuration: Optional[Configuration]
    def supplementaryConfiguration: Optional[
      Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
    ]
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getConfigurationItemCaptureTime
        : ZIO[Any, AwsError, ConfigurationItemCaptureTime] =
      AwsError.unwrapOptionField(
        "configurationItemCaptureTime",
        configurationItemCaptureTime
      )
    def getConfigurationItemStatus
        : ZIO[Any, AwsError, zio.aws.config.model.ConfigurationItemStatus] =
      AwsError.unwrapOptionField(
        "configurationItemStatus",
        configurationItemStatus
      )
    def getConfigurationStateId: ZIO[Any, AwsError, ConfigurationStateId] =
      AwsError.unwrapOptionField("configurationStateId", configurationStateId)
    def getConfigurationItemMD5Hash
        : ZIO[Any, AwsError, ConfigurationItemMD5Hash] = AwsError
      .unwrapOptionField("configurationItemMD5Hash", configurationItemMD5Hash)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZone] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getResourceCreationTime: ZIO[Any, AwsError, ResourceCreationTime] =
      AwsError.unwrapOptionField("resourceCreationTime", resourceCreationTime)
    def getTags: ZIO[Any, AwsError, Map[Name, Value]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRelatedEvents: ZIO[Any, AwsError, List[RelatedEvent]] =
      AwsError.unwrapOptionField("relatedEvents", relatedEvents)
    def getRelationships
        : ZIO[Any, AwsError, List[zio.aws.config.model.Relationship.ReadOnly]] =
      AwsError.unwrapOptionField("relationships", relationships)
    def getConfiguration: ZIO[Any, AwsError, Configuration] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getSupplementaryConfiguration: ZIO[Any, AwsError, Map[
      SupplementaryConfigurationName,
      SupplementaryConfigurationValue
    ]] = AwsError.unwrapOptionField(
      "supplementaryConfiguration",
      supplementaryConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigurationItem
  ) extends zio.aws.config.model.ConfigurationItem.ReadOnly {
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.config.model.primitives.Version(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val configurationItemCaptureTime
        : Optional[ConfigurationItemCaptureTime] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationItemCaptureTime())
      .map(value =>
        zio.aws.config.model.primitives.ConfigurationItemCaptureTime(value)
      )
    override val configurationItemStatus
        : Optional[zio.aws.config.model.ConfigurationItemStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationItemStatus())
        .map(value => zio.aws.config.model.ConfigurationItemStatus.wrap(value))
    override val configurationStateId: Optional[ConfigurationStateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationStateId())
        .map(value =>
          zio.aws.config.model.primitives.ConfigurationStateId(value)
        )
    override val configurationItemMD5Hash: Optional[ConfigurationItemMD5Hash] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationItemMD5Hash())
        .map(value =>
          zio.aws.config.model.primitives.ConfigurationItemMD5Hash(value)
        )
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.config.model.primitives.ARN(value))
    override val resourceType: Optional[zio.aws.config.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.ResourceId(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
    override val availabilityZone: Optional[AvailabilityZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value => zio.aws.config.model.primitives.AvailabilityZone(value))
    override val resourceCreationTime: Optional[ResourceCreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCreationTime())
        .map(value =>
          zio.aws.config.model.primitives.ResourceCreationTime(value)
        )
    override val tags: Optional[Map[Name, Value]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.config.model.primitives
              .Name(key) -> zio.aws.config.model.primitives.Value(value)
          })
          .toMap
      )
    override val relatedEvents: Optional[List[RelatedEvent]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.RelatedEvent(item)
          }.toList
        )
    override val relationships
        : Optional[List[zio.aws.config.model.Relationship.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.Relationship.wrap(item)
          }.toList
        )
    override val configuration: Optional[Configuration] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value => zio.aws.config.model.primitives.Configuration(value))
    override val supplementaryConfiguration: Optional[
      Map[SupplementaryConfigurationName, SupplementaryConfigurationValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementaryConfiguration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.config.model.primitives.SupplementaryConfigurationName(
              key
            ) -> zio.aws.config.model.primitives
              .SupplementaryConfigurationValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigurationItem
  ): zio.aws.config.model.ConfigurationItem.ReadOnly = new Wrapper(impl)
}
