package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit64
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConformancePackComplianceFilters(
    configRuleNames: Optional[Iterable[StringWithCharLimit64]] =
      Optional.Absent,
    complianceType: Optional[
      zio.aws.config.model.ConformancePackComplianceType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackComplianceFilters = {
    import ConformancePackComplianceFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackComplianceFilters
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            StringWithCharLimit64.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly =
    zio.aws.config.model.ConformancePackComplianceFilters.wrap(buildAwsValue())
}
object ConformancePackComplianceFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackComplianceFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackComplianceFilters =
      zio.aws.config.model.ConformancePackComplianceFilters(
        configRuleNames.map(value => value),
        complianceType.map(value => value)
      )
    def configRuleNames: Optional[List[StringWithCharLimit64]]
    def complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType]
    def getConfigRuleNames: ZIO[Any, AwsError, List[StringWithCharLimit64]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceFilters
  ) extends zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly {
    override val configRuleNames: Optional[List[StringWithCharLimit64]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit64(item)
          }.toList
        )
    override val complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.config.model.ConformancePackComplianceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceFilters
  ): zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly =
    new Wrapper(impl)
}
