package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConformancePackName
import scala.jdk.CollectionConverters.*
final case class ConformancePackComplianceSummary(
    conformancePackName: ConformancePackName,
    conformancePackComplianceStatus: zio.aws.config.model.ConformancePackComplianceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary = {
    import ConformancePackComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .conformancePackComplianceStatus(conformancePackComplianceStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly =
    zio.aws.config.model.ConformancePackComplianceSummary.wrap(buildAwsValue())
}
object ConformancePackComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackComplianceSummary =
      zio.aws.config.model.ConformancePackComplianceSummary(
        conformancePackName,
        conformancePackComplianceStatus
      )
    def conformancePackName: ConformancePackName
    def conformancePackComplianceStatus
        : zio.aws.config.model.ConformancePackComplianceType
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getConformancePackComplianceStatus: ZIO[
      Any,
      Nothing,
      zio.aws.config.model.ConformancePackComplianceType
    ] = ZIO.succeed(conformancePackComplianceStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary
  ) extends zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val conformancePackComplianceStatus
        : zio.aws.config.model.ConformancePackComplianceType =
      zio.aws.config.model.ConformancePackComplianceType
        .wrap(impl.conformancePackComplianceStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackComplianceSummary
  ): zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly =
    new Wrapper(impl)
}
