package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ConformancePackComplianceType {
  def unwrap: software.amazon.awssdk.services.config.model.ConformancePackComplianceType
}
object ConformancePackComplianceType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ConformancePackComplianceType
  ): zio.aws.config.model.ConformancePackComplianceType = value match {
    case software.amazon.awssdk.services.config.model.ConformancePackComplianceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ConformancePackComplianceType.COMPLIANT =>
      val r = COMPLIANT
      r
    case software.amazon.awssdk.services.config.model.ConformancePackComplianceType.NON_COMPLIANT =>
      val r = NON_COMPLIANT
      r
    case software.amazon.awssdk.services.config.model.ConformancePackComplianceType.INSUFFICIENT_DATA =>
      val r = INSUFFICIENT_DATA
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ConformancePackComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackComplianceType =
      software.amazon.awssdk.services.config.model.ConformancePackComplianceType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANT
      extends zio.aws.config.model.ConformancePackComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackComplianceType =
      software.amazon.awssdk.services.config.model.ConformancePackComplianceType.COMPLIANT
  }
  case object NON_COMPLIANT
      extends zio.aws.config.model.ConformancePackComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackComplianceType =
      software.amazon.awssdk.services.config.model.ConformancePackComplianceType.NON_COMPLIANT
  }
  case object INSUFFICIENT_DATA
      extends zio.aws.config.model.ConformancePackComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConformancePackComplianceType =
      software.amazon.awssdk.services.config.model.ConformancePackComplianceType.INSUFFICIENT_DATA
  }
}
