package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  StringWithCharLimit256,
  StringWithCharLimit64
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConformancePackEvaluationFilters(
    configRuleNames: Optional[Iterable[StringWithCharLimit64]] =
      Optional.Absent,
    complianceType: Optional[
      zio.aws.config.model.ConformancePackComplianceType
    ] = Optional.Absent,
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    resourceIds: Optional[Iterable[StringWithCharLimit256]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackEvaluationFilters = {
    import ConformancePackEvaluationFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackEvaluationFilters
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            StringWithCharLimit64.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConformancePackEvaluationFilters.ReadOnly =
    zio.aws.config.model.ConformancePackEvaluationFilters.wrap(buildAwsValue())
}
object ConformancePackEvaluationFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackEvaluationFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackEvaluationFilters =
      zio.aws.config.model.ConformancePackEvaluationFilters(
        configRuleNames.map(value => value),
        complianceType.map(value => value),
        resourceType.map(value => value),
        resourceIds.map(value => value)
      )
    def configRuleNames: Optional[List[StringWithCharLimit64]]
    def complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType]
    def resourceType: Optional[StringWithCharLimit256]
    def resourceIds: Optional[List[StringWithCharLimit256]]
    def getConfigRuleNames: ZIO[Any, AwsError, List[StringWithCharLimit64]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceIds: ZIO[Any, AwsError, List[StringWithCharLimit256]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackEvaluationFilters
  ) extends zio.aws.config.model.ConformancePackEvaluationFilters.ReadOnly {
    override val configRuleNames: Optional[List[StringWithCharLimit64]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit64(item)
          }.toList
        )
    override val complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.config.model.ConformancePackComplianceType.wrap(value)
        )
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val resourceIds: Optional[List[StringWithCharLimit256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit256(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackEvaluationFilters
  ): zio.aws.config.model.ConformancePackEvaluationFilters.ReadOnly =
    new Wrapper(impl)
}
