package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  ConformancePackName,
  Date,
  ConformancePackStatusReason,
  ConformancePackArn,
  ConformancePackId,
  StackArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConformancePackStatusDetail(
    conformancePackName: ConformancePackName,
    conformancePackId: ConformancePackId,
    conformancePackArn: ConformancePackArn,
    conformancePackState: zio.aws.config.model.ConformancePackState,
    stackArn: StackArn,
    conformancePackStatusReason: Optional[ConformancePackStatusReason] =
      Optional.Absent,
    lastUpdateRequestedTime: Date,
    lastUpdateCompletedTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackStatusDetail = {
    import ConformancePackStatusDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackStatusDetail
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .conformancePackId(
        ConformancePackId.unwrap(conformancePackId): java.lang.String
      )
      .conformancePackArn(
        ConformancePackArn.unwrap(conformancePackArn): java.lang.String
      )
      .conformancePackState(conformancePackState.unwrap)
      .stackArn(StackArn.unwrap(stackArn): java.lang.String)
      .optionallyWith(
        conformancePackStatusReason.map(value =>
          ConformancePackStatusReason.unwrap(value): java.lang.String
        )
      )(_.conformancePackStatusReason)
      .lastUpdateRequestedTime(Date.unwrap(lastUpdateRequestedTime): Instant)
      .optionallyWith(
        lastUpdateCompletedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdateCompletedTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConformancePackStatusDetail.ReadOnly =
    zio.aws.config.model.ConformancePackStatusDetail.wrap(buildAwsValue())
}
object ConformancePackStatusDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackStatusDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackStatusDetail =
      zio.aws.config.model.ConformancePackStatusDetail(
        conformancePackName,
        conformancePackId,
        conformancePackArn,
        conformancePackState,
        stackArn,
        conformancePackStatusReason.map(value => value),
        lastUpdateRequestedTime,
        lastUpdateCompletedTime.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def conformancePackId: ConformancePackId
    def conformancePackArn: ConformancePackArn
    def conformancePackState: zio.aws.config.model.ConformancePackState
    def stackArn: StackArn
    def conformancePackStatusReason: Optional[ConformancePackStatusReason]
    def lastUpdateRequestedTime: Date
    def lastUpdateCompletedTime: Optional[Date]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getConformancePackId: ZIO[Any, Nothing, ConformancePackId] =
      ZIO.succeed(conformancePackId)
    def getConformancePackArn: ZIO[Any, Nothing, ConformancePackArn] =
      ZIO.succeed(conformancePackArn)
    def getConformancePackState
        : ZIO[Any, Nothing, zio.aws.config.model.ConformancePackState] =
      ZIO.succeed(conformancePackState)
    def getStackArn: ZIO[Any, Nothing, StackArn] = ZIO.succeed(stackArn)
    def getConformancePackStatusReason
        : ZIO[Any, AwsError, ConformancePackStatusReason] =
      AwsError.unwrapOptionField(
        "conformancePackStatusReason",
        conformancePackStatusReason
      )
    def getLastUpdateRequestedTime: ZIO[Any, Nothing, Date] =
      ZIO.succeed(lastUpdateRequestedTime)
    def getLastUpdateCompletedTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("lastUpdateCompletedTime", lastUpdateCompletedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackStatusDetail
  ) extends zio.aws.config.model.ConformancePackStatusDetail.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val conformancePackId: ConformancePackId =
      zio.aws.config.model.primitives
        .ConformancePackId(impl.conformancePackId())
    override val conformancePackArn: ConformancePackArn =
      zio.aws.config.model.primitives
        .ConformancePackArn(impl.conformancePackArn())
    override val conformancePackState
        : zio.aws.config.model.ConformancePackState =
      zio.aws.config.model.ConformancePackState
        .wrap(impl.conformancePackState())
    override val stackArn: StackArn =
      zio.aws.config.model.primitives.StackArn(impl.stackArn())
    override val conformancePackStatusReason
        : Optional[ConformancePackStatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.conformancePackStatusReason())
      .map(value =>
        zio.aws.config.model.primitives.ConformancePackStatusReason(value)
      )
    override val lastUpdateRequestedTime: Date =
      zio.aws.config.model.primitives.Date(impl.lastUpdateRequestedTime())
    override val lastUpdateCompletedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateCompletedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackStatusDetail
  ): zio.aws.config.model.ConformancePackStatusDetail.ReadOnly = new Wrapper(
    impl
  )
}
