package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import scala.jdk.CollectionConverters.*
final case class DeleteAggregationAuthorizationRequest(
    authorizedAccountId: AccountId,
    authorizedAwsRegion: AwsRegion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest = {
    import DeleteAggregationAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest
      .builder()
      .authorizedAccountId(
        AccountId.unwrap(authorizedAccountId): java.lang.String
      )
      .authorizedAwsRegion(
        AwsRegion.unwrap(authorizedAwsRegion): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeleteAggregationAuthorizationRequest.ReadOnly =
    zio.aws.config.model.DeleteAggregationAuthorizationRequest
      .wrap(buildAwsValue())
}
object DeleteAggregationAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteAggregationAuthorizationRequest =
      zio.aws.config.model.DeleteAggregationAuthorizationRequest(
        authorizedAccountId,
        authorizedAwsRegion
      )
    def authorizedAccountId: AccountId
    def authorizedAwsRegion: AwsRegion
    def getAuthorizedAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(authorizedAccountId)
    def getAuthorizedAwsRegion: ZIO[Any, Nothing, AwsRegion] =
      ZIO.succeed(authorizedAwsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest
  ) extends zio.aws.config.model.DeleteAggregationAuthorizationRequest.ReadOnly {
    override val authorizedAccountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.authorizedAccountId())
    override val authorizedAwsRegion: AwsRegion =
      zio.aws.config.model.primitives.AwsRegion(impl.authorizedAwsRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest
  ): zio.aws.config.model.DeleteAggregationAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
