package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.StringWithCharLimit64
import scala.jdk.CollectionConverters.*
final case class DeleteEvaluationResultsRequest(
    configRuleName: StringWithCharLimit64
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest = {
    import DeleteEvaluationResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest
      .builder()
      .configRuleName(
        StringWithCharLimit64.unwrap(configRuleName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeleteEvaluationResultsRequest.ReadOnly =
    zio.aws.config.model.DeleteEvaluationResultsRequest.wrap(buildAwsValue())
}
object DeleteEvaluationResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteEvaluationResultsRequest =
      zio.aws.config.model.DeleteEvaluationResultsRequest(configRuleName)
    def configRuleName: StringWithCharLimit64
    def getConfigRuleName: ZIO[Any, Nothing, StringWithCharLimit64] =
      ZIO.succeed(configRuleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest
  ) extends zio.aws.config.model.DeleteEvaluationResultsRequest.ReadOnly {
    override val configRuleName: StringWithCharLimit64 =
      zio.aws.config.model.primitives
        .StringWithCharLimit64(impl.configRuleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest
  ): zio.aws.config.model.DeleteEvaluationResultsRequest.ReadOnly = new Wrapper(
    impl
  )
}
