package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import scala.jdk.CollectionConverters.*
final case class DeletePendingAggregationRequestRequest(
    requesterAccountId: AccountId,
    requesterAwsRegion: AwsRegion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest = {
    import DeletePendingAggregationRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest
      .builder()
      .requesterAccountId(
        AccountId.unwrap(requesterAccountId): java.lang.String
      )
      .requesterAwsRegion(
        AwsRegion.unwrap(requesterAwsRegion): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeletePendingAggregationRequestRequest.ReadOnly =
    zio.aws.config.model.DeletePendingAggregationRequestRequest
      .wrap(buildAwsValue())
}
object DeletePendingAggregationRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DeletePendingAggregationRequestRequest =
      zio.aws.config.model.DeletePendingAggregationRequestRequest(
        requesterAccountId,
        requesterAwsRegion
      )
    def requesterAccountId: AccountId
    def requesterAwsRegion: AwsRegion
    def getRequesterAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(requesterAccountId)
    def getRequesterAwsRegion: ZIO[Any, Nothing, AwsRegion] =
      ZIO.succeed(requesterAwsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest
  ) extends zio.aws.config.model.DeletePendingAggregationRequestRequest.ReadOnly {
    override val requesterAccountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.requesterAccountId())
    override val requesterAwsRegion: AwsRegion =
      zio.aws.config.model.primitives.AwsRegion(impl.requesterAwsRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest
  ): zio.aws.config.model.DeletePendingAggregationRequestRequest.ReadOnly =
    new Wrapper(impl)
}
