package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class DeleteRemediationExceptionsRequest(
    configRuleName: ConfigRuleName,
    resourceKeys: Iterable[zio.aws.config.model.RemediationExceptionResourceKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest = {
    import DeleteRemediationExceptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .resourceKeys(resourceKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeleteRemediationExceptionsRequest.ReadOnly =
    zio.aws.config.model.DeleteRemediationExceptionsRequest
      .wrap(buildAwsValue())
}
object DeleteRemediationExceptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteRemediationExceptionsRequest =
      zio.aws.config.model.DeleteRemediationExceptionsRequest(
        configRuleName,
        resourceKeys.map { item =>
          item.asEditable
        }
      )
    def configRuleName: ConfigRuleName
    def resourceKeys
        : List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceKeys: ZIO[Any, Nothing, List[
      zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly
    ]] = ZIO.succeed(resourceKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest
  ) extends zio.aws.config.model.DeleteRemediationExceptionsRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceKeys
        : List[zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly] =
      impl
        .resourceKeys()
        .asScala
        .map { item =>
          zio.aws.config.model.RemediationExceptionResourceKey.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest
  ): zio.aws.config.model.DeleteRemediationExceptionsRequest.ReadOnly =
    new Wrapper(impl)
}
