package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.RetentionConfigurationName
import scala.jdk.CollectionConverters.*
final case class DeleteRetentionConfigurationRequest(
    retentionConfigurationName: RetentionConfigurationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest = {
    import DeleteRetentionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest
      .builder()
      .retentionConfigurationName(
        RetentionConfigurationName.unwrap(
          retentionConfigurationName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DeleteRetentionConfigurationRequest.ReadOnly =
    zio.aws.config.model.DeleteRetentionConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteRetentionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteRetentionConfigurationRequest =
      zio.aws.config.model
        .DeleteRetentionConfigurationRequest(retentionConfigurationName)
    def retentionConfigurationName: RetentionConfigurationName
    def getRetentionConfigurationName
        : ZIO[Any, Nothing, RetentionConfigurationName] =
      ZIO.succeed(retentionConfigurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest
  ) extends zio.aws.config.model.DeleteRetentionConfigurationRequest.ReadOnly {
    override val retentionConfigurationName: RetentionConfigurationName =
      zio.aws.config.model.primitives
        .RetentionConfigurationName(impl.retentionConfigurationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest
  ): zio.aws.config.model.DeleteRetentionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
