package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  ConfigurationAggregatorName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeAggregateComplianceByConformancePacksRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    filters: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceFilters
    ] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest = {
    import DescribeAggregateComplianceByConformancePacksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest.ReadOnly =
    zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest
      .wrap(buildAwsValue())
}
object DescribeAggregateComplianceByConformancePacksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest =
      zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest(
        configurationAggregatorName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def filters: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceFilters.ReadOnly
    ]
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregateConformancePackComplianceFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ) extends zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val filters: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.config.model.AggregateConformancePackComplianceFilters
          .wrap(value)
      )
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest
  ): zio.aws.config.model.DescribeAggregateComplianceByConformancePacksRequest.ReadOnly =
    new Wrapper(impl)
}
