package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Limit
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeAggregationAuthorizationsRequest(
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest = {
    import DescribeAggregationAuthorizationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest
      .builder()
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeAggregationAuthorizationsRequest.ReadOnly =
    zio.aws.config.model.DescribeAggregationAuthorizationsRequest
      .wrap(buildAwsValue())
}
object DescribeAggregationAuthorizationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeAggregationAuthorizationsRequest =
      zio.aws.config.model.DescribeAggregationAuthorizationsRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[Limit]
    def nextToken: Optional[String]
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest
  ) extends zio.aws.config.model.DescribeAggregationAuthorizationsRequest.ReadOnly {
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest
  ): zio.aws.config.model.DescribeAggregationAuthorizationsRequest.ReadOnly =
    new Wrapper(impl)
}
