package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigRuleName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeComplianceByConfigRuleRequest(
    configRuleNames: Optional[Iterable[ConfigRuleName]] = Optional.Absent,
    complianceTypes: Optional[Iterable[zio.aws.config.model.ComplianceType]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest = {
    import DescribeComplianceByConfigRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            ConfigRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .optionallyWith(
        complianceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.complianceTypesWithStrings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeComplianceByConfigRuleRequest.ReadOnly =
    zio.aws.config.model.DescribeComplianceByConfigRuleRequest
      .wrap(buildAwsValue())
}
object DescribeComplianceByConfigRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeComplianceByConfigRuleRequest =
      zio.aws.config.model.DescribeComplianceByConfigRuleRequest(
        configRuleNames.map(value => value),
        complianceTypes.map(value => value),
        nextToken.map(value => value)
      )
    def configRuleNames: Optional[List[ConfigRuleName]]
    def complianceTypes: Optional[List[zio.aws.config.model.ComplianceType]]
    def nextToken: Optional[String]
    def getConfigRuleNames: ZIO[Any, AwsError, List[ConfigRuleName]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
    def getComplianceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ComplianceType]] =
      AwsError.unwrapOptionField("complianceTypes", complianceTypes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest
  ) extends zio.aws.config.model.DescribeComplianceByConfigRuleRequest.ReadOnly {
    override val configRuleNames: Optional[List[ConfigRuleName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ConfigRuleName(item)
          }.toList
        )
    override val complianceTypes
        : Optional[List[zio.aws.config.model.ComplianceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ComplianceType.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest
  ): zio.aws.config.model.DescribeComplianceByConfigRuleRequest.ReadOnly =
    new Wrapper(impl)
}
