package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  BaseResourceId,
  StringWithCharLimit256
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeComplianceByResourceRequest(
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    resourceId: Optional[BaseResourceId] = Optional.Absent,
    complianceTypes: Optional[Iterable[zio.aws.config.model.ComplianceType]] =
      Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest = {
    import DescribeComplianceByResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        complianceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.complianceTypesWithStrings)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeComplianceByResourceRequest.ReadOnly =
    zio.aws.config.model.DescribeComplianceByResourceRequest
      .wrap(buildAwsValue())
}
object DescribeComplianceByResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeComplianceByResourceRequest =
      zio.aws.config.model.DescribeComplianceByResourceRequest(
        resourceType.map(value => value),
        resourceId.map(value => value),
        complianceTypes.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def resourceType: Optional[StringWithCharLimit256]
    def resourceId: Optional[BaseResourceId]
    def complianceTypes: Optional[List[zio.aws.config.model.ComplianceType]]
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getComplianceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ComplianceType]] =
      AwsError.unwrapOptionField("complianceTypes", complianceTypes)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
  ) extends zio.aws.config.model.DescribeComplianceByResourceRequest.ReadOnly {
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val resourceId: Optional[BaseResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
    override val complianceTypes
        : Optional[List[zio.aws.config.model.ComplianceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ComplianceType.wrap(item)
          }.toList
        )
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
  ): zio.aws.config.model.DescribeComplianceByResourceRequest.ReadOnly =
    new Wrapper(impl)
}
