package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRulesResponse(
    configRules: Optional[Iterable[zio.aws.config.model.ConfigRule]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse = {
    import DescribeConfigRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse
      .builder()
      .optionallyWith(
        configRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configRules)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigRulesResponse.wrap(buildAwsValue())
}
object DescribeConfigRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConfigRulesResponse =
      zio.aws.config.model.DescribeConfigRulesResponse(
        configRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configRules: Optional[List[zio.aws.config.model.ConfigRule.ReadOnly]]
    def nextToken: Optional[String]
    def getConfigRules
        : ZIO[Any, AwsError, List[zio.aws.config.model.ConfigRule.ReadOnly]] =
      AwsError.unwrapOptionField("configRules", configRules)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse
  ) extends zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly {
    override val configRules
        : Optional[List[zio.aws.config.model.ConfigRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ConfigRule.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse
  ): zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly = new Wrapper(
    impl
  )
}
