package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  DescribeConformancePackComplianceLimit,
  ConformancePackName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeConformancePackComplianceRequest(
    conformancePackName: ConformancePackName,
    filters: Optional[zio.aws.config.model.ConformancePackComplianceFilters] =
      Optional.Absent,
    limit: Optional[DescribeConformancePackComplianceLimit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest = {
    import DescribeConformancePackComplianceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value =>
          DescribeConformancePackComplianceLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConformancePackComplianceRequest.ReadOnly =
    zio.aws.config.model.DescribeConformancePackComplianceRequest
      .wrap(buildAwsValue())
}
object DescribeConformancePackComplianceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConformancePackComplianceRequest =
      zio.aws.config.model.DescribeConformancePackComplianceRequest(
        conformancePackName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def filters: Optional[
      zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly
    ]
    def limit: Optional[DescribeConformancePackComplianceLimit]
    def nextToken: Optional[NextToken]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, DescribeConformancePackComplianceLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
  ) extends zio.aws.config.model.DescribeConformancePackComplianceRequest.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val filters: Optional[
      zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.config.model.ConformancePackComplianceFilters.wrap(value)
      )
    override val limit: Optional[DescribeConformancePackComplianceLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.config.model.primitives
            .DescribeConformancePackComplianceLimit(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
  ): zio.aws.config.model.DescribeConformancePackComplianceRequest.ReadOnly =
    new Wrapper(impl)
}
