package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationConfigurationsRequest(
    configRuleNames: Iterable[ConfigRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest = {
    import DescribeRemediationConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest
      .builder()
      .configRuleNames(configRuleNames.map { item =>
        ConfigRuleName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationConfigurationsRequest.ReadOnly =
    zio.aws.config.model.DescribeRemediationConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeRemediationConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRemediationConfigurationsRequest =
      zio.aws.config.model
        .DescribeRemediationConfigurationsRequest(configRuleNames)
    def configRuleNames: List[ConfigRuleName]
    def getConfigRuleNames: ZIO[Any, Nothing, List[ConfigRuleName]] =
      ZIO.succeed(configRuleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest
  ) extends zio.aws.config.model.DescribeRemediationConfigurationsRequest.ReadOnly {
    override val configRuleNames: List[ConfigRuleName] = impl
      .configRuleNames()
      .asScala
      .map { item =>
        zio.aws.config.model.primitives.ConfigRuleName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest
  ): zio.aws.config.model.DescribeRemediationConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
