package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationConfigurationsResponse(
    remediationConfigurations: Optional[
      Iterable[zio.aws.config.model.RemediationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse = {
    import DescribeRemediationConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse
      .builder()
      .optionallyWith(
        remediationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remediationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly =
    zio.aws.config.model.DescribeRemediationConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeRemediationConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRemediationConfigurationsResponse =
      zio.aws.config.model.DescribeRemediationConfigurationsResponse(
        remediationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def remediationConfigurations
        : Optional[List[zio.aws.config.model.RemediationConfiguration.ReadOnly]]
    def getRemediationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "remediationConfigurations",
      remediationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse
  ) extends zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly {
    override val remediationConfigurations: Optional[
      List[zio.aws.config.model.RemediationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.remediationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.RemediationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse
  ): zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
