package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationExceptionsResponse(
    remediationExceptions: Optional[
      Iterable[zio.aws.config.model.RemediationException]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse = {
    import DescribeRemediationExceptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse
      .builder()
      .optionallyWith(
        remediationExceptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remediationExceptions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly =
    zio.aws.config.model.DescribeRemediationExceptionsResponse
      .wrap(buildAwsValue())
}
object DescribeRemediationExceptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeRemediationExceptionsResponse =
      zio.aws.config.model.DescribeRemediationExceptionsResponse(
        remediationExceptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def remediationExceptions
        : Optional[List[zio.aws.config.model.RemediationException.ReadOnly]]
    def nextToken: Optional[String]
    def getRemediationExceptions: ZIO[Any, AwsError, List[
      zio.aws.config.model.RemediationException.ReadOnly
    ]] =
      AwsError.unwrapOptionField("remediationExceptions", remediationExceptions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse
  ) extends zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly {
    override val remediationExceptions
        : Optional[List[zio.aws.config.model.RemediationException.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediationExceptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.RemediationException.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse
  ): zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly =
    new Wrapper(impl)
}
