package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Limit, ConfigRuleName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeRemediationExecutionStatusRequest(
    configRuleName: ConfigRuleName,
    resourceKeys: Optional[Iterable[zio.aws.config.model.ResourceKey]] =
      Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest = {
    import DescribeRemediationExecutionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .optionallyWith(
        resourceKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceKeys)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRemediationExecutionStatusRequest.ReadOnly =
    zio.aws.config.model.DescribeRemediationExecutionStatusRequest
      .wrap(buildAwsValue())
}
object DescribeRemediationExecutionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRemediationExecutionStatusRequest =
      zio.aws.config.model.DescribeRemediationExecutionStatusRequest(
        configRuleName,
        resourceKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configRuleName: ConfigRuleName
    def resourceKeys: Optional[List[zio.aws.config.model.ResourceKey.ReadOnly]]
    def limit: Optional[Limit]
    def nextToken: Optional[String]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceKeys
        : ZIO[Any, AwsError, List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      AwsError.unwrapOptionField("resourceKeys", resourceKeys)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest
  ) extends zio.aws.config.model.DescribeRemediationExecutionStatusRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceKeys
        : Optional[List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ResourceKey.wrap(item)
          }.toList
        )
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest
  ): zio.aws.config.model.DescribeRemediationExecutionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
