package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, RetentionConfigurationName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRetentionConfigurationsRequest(
    retentionConfigurationNames: Optional[
      Iterable[RetentionConfigurationName]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest = {
    import DescribeRetentionConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
      .builder()
      .optionallyWith(
        retentionConfigurationNames.map(value =>
          value.map { item =>
            RetentionConfigurationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.retentionConfigurationNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRetentionConfigurationsRequest.ReadOnly =
    zio.aws.config.model.DescribeRetentionConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeRetentionConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRetentionConfigurationsRequest =
      zio.aws.config.model.DescribeRetentionConfigurationsRequest(
        retentionConfigurationNames.map(value => value),
        nextToken.map(value => value)
      )
    def retentionConfigurationNames: Optional[List[RetentionConfigurationName]]
    def nextToken: Optional[NextToken]
    def getRetentionConfigurationNames
        : ZIO[Any, AwsError, List[RetentionConfigurationName]] =
      AwsError.unwrapOptionField(
        "retentionConfigurationNames",
        retentionConfigurationNames
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
  ) extends zio.aws.config.model.DescribeRetentionConfigurationsRequest.ReadOnly {
    override val retentionConfigurationNames
        : Optional[List[RetentionConfigurationName]] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionConfigurationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.RetentionConfigurationName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
  ): zio.aws.config.model.DescribeRetentionConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
