package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRetentionConfigurationsResponse(
    retentionConfigurations: Optional[
      Iterable[zio.aws.config.model.RetentionConfiguration]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse = {
    import DescribeRetentionConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
      .builder()
      .optionallyWith(
        retentionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.retentionConfigurations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly =
    zio.aws.config.model.DescribeRetentionConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeRetentionConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRetentionConfigurationsResponse =
      zio.aws.config.model.DescribeRetentionConfigurationsResponse(
        retentionConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def retentionConfigurations
        : Optional[List[zio.aws.config.model.RetentionConfiguration.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRetentionConfigurations: ZIO[Any, AwsError, List[
      zio.aws.config.model.RetentionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "retentionConfigurations",
      retentionConfigurations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
  ) extends zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly {
    override val retentionConfigurations
        : Optional[List[zio.aws.config.model.RetentionConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.RetentionConfiguration.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
  ): zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
