package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  BaseResourceId,
  StringWithCharLimit256,
  ConfigRuleName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationResultQualifier(
    configRuleName: Optional[ConfigRuleName] = Optional.Absent,
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    resourceId: Optional[BaseResourceId] = Optional.Absent,
    evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationResultQualifier = {
    import EvaluationResultQualifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationResultQualifier
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(evaluationMode.map(value => value.unwrap))(
        _.evaluationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationResultQualifier.ReadOnly =
    zio.aws.config.model.EvaluationResultQualifier.wrap(buildAwsValue())
}
object EvaluationResultQualifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationResultQualifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationResultQualifier =
      zio.aws.config.model.EvaluationResultQualifier(
        configRuleName.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        evaluationMode.map(value => value)
      )
    def configRuleName: Optional[ConfigRuleName]
    def resourceType: Optional[StringWithCharLimit256]
    def resourceId: Optional[BaseResourceId]
    def evaluationMode: Optional[zio.aws.config.model.EvaluationMode]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getEvaluationMode
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationMode] =
      AwsError.unwrapOptionField("evaluationMode", evaluationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationResultQualifier
  ) extends zio.aws.config.model.EvaluationResultQualifier.ReadOnly {
    override val configRuleName: Optional[ConfigRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val resourceId: Optional[BaseResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
    override val evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationMode())
        .map(value => zio.aws.config.model.EvaluationMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationResultQualifier
  ): zio.aws.config.model.EvaluationResultQualifier.ReadOnly = new Wrapper(impl)
}
