package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  ConfigurationAggregatorName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAggregateConformancePackComplianceSummaryRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    filters: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceSummaryFilters
    ] = Optional.Absent,
    groupByKey: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceSummaryGroupKey
    ] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest = {
    import GetAggregateConformancePackComplianceSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(groupByKey.map(value => value.unwrap))(_.groupByKey)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest.ReadOnly =
    zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest
      .wrap(buildAwsValue())
}
object GetAggregateConformancePackComplianceSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest =
      zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest(
        configurationAggregatorName,
        filters.map(value => value.asEditable),
        groupByKey.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def filters: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceSummaryFilters.ReadOnly
    ]
    def groupByKey: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceSummaryGroupKey
    ]
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregateConformancePackComplianceSummaryFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getGroupByKey: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregateConformancePackComplianceSummaryGroupKey
    ] = AwsError.unwrapOptionField("groupByKey", groupByKey)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ) extends zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val filters: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceSummaryFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.config.model.AggregateConformancePackComplianceSummaryFilters
          .wrap(value)
      )
    override val groupByKey: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceSummaryGroupKey
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupByKey())
      .map(value =>
        zio.aws.config.model.AggregateConformancePackComplianceSummaryGroupKey
          .wrap(value)
      )
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest
  ): zio.aws.config.model.GetAggregateConformancePackComplianceSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
